
#include "IOT_Drone.h"
#include "Arduino.h"
//------------------------------------------------------------------------------------//

Stream* _serial;
bool _isAvailable = false;
bool _isSending = false;
  
bool _sendHWSerial = false;
bool _sendSoftSerial = false;
  
  
  
  
//------------------------------------------------------------------------------------//


boolean changeBaudrate = false;
//------------------------------------------------------------------------------------//

//------------------------------------------------------------------------------------//

void set_serial(byte sendSerial)
{
	if(sendSerial == SEND_SERIAL_HW)
	{
		_sendHWSerial = true;
	}
	else if(sendSerial == SEND_SERIAL_SOFT)
	{
		_sendSoftSerial = true;
	}
	 
}

  
//------------------------------------------------------------------------------------//

bool begin_serial(Stream &stream)
{
  _serial = &stream;
  
  /*
  if (isACK) {
    enableACK();
  }
  else{
    disableACK();
  }
  
  if (doReset) 
  {
    reset();
    waitAvailable(2000);
    delay(200);
  }
  else {
    // assume same state as with reset(): online
    _handleType = DFPlayerCardOnline;
  }
*/
 // return (readType() == DFPlayerCardOnline) || (readType() == DFPlayerUSBOnline) || !isACK;

return true;
}

void send_write(unsigned char data[],int length)
{
	_serial->write(data, length);
}

void send_byte(unsigned char data)
{
	_serial->write(data);
//	softSerial.write(_data);
}

//------------------------------------------------------------------------------------//







//---------------------------------------------------------------------------//

static const unsigned short crc16tab[256] = {
  0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
  0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
  0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
  0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
  0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
  0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
  0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
  0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
  0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
  0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
  0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
  0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
  0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
  0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
  0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
  0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
  0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
  0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
  0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
  0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
  0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
  0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
  0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
  0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
  0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
  0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
  0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
  0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
  0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
  0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
  0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
  0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
};

unsigned short CRC16_Make(unsigned char *buf, int len) //CRC16-CCITT Format
{
  unsigned short crc = 0 ;
  for (int counter = 0; counter < len; counter++) crc = (crc << 8) ^ crc16tab[((crc >> 8) ^ * (char *)buf++) & 0x00FF];
  return crc;
}

boolean CRC16_Check(unsigned char data[], int len, unsigned char crc[])
{
  boolean crcCheck = false;

  unsigned short receiveCRC = ((crc[1] << 8) | (crc[0] & 0xff));
  unsigned short makeCRC = CRC16_Make(data, len + 2);

  if (receiveCRC == makeCRC)        crcCheck = true;

  return crcCheck;
}

//----------------------------------------------------------------------------------------//

void requestAttitude(int _roll, int _pitch, int _yaw)
{
  RFsendProcess(SEND_SERIAL_SOFT, Attitude, 6,  Drone, Base,
                ((_roll & 0xff) | (_roll  & 0xff00)),
                ((_pitch & 0xff) | (_pitch  & 0xff00)),
                ((_yaw & 0xff) | (_yaw  & 0xff00)));
}



void requestAll(byte _accX, byte _accY, byte _accZ, int _roll, int _pitch, int _yaw, 
                 int _left_x, int _left_y, int _right_x, int _right_y, 
                 byte but, byte micLV, byte batPercent
                 )
{
  _left_x =  map(_left_x, 0, 1023, -100, 100);
  _left_y =  map(_left_y, 0, 1023, -100, 100);
  _right_x =  map(_right_x, 0, 1023, 100, -100);
  _right_y =  map(_right_y, 0, 1023, 100, -100);

  int analogOffset = 10;

  if ((_left_x > -1 * analogOffset) && (_left_x < analogOffset)) _left_x = 0;
  if ((_left_y > -1 * analogOffset) && (_left_y < analogOffset)) _left_y = 0;
  if ((_right_x > -1 * analogOffset) && (_right_x < analogOffset)) _right_x = 0;
  if ((_right_y > -1 * analogOffset) && (_right_y < analogOffset)) _right_y = 0;


  byte _lx = (char)_left_x;
  byte _ly = (char)_left_y;

  byte _rx = (char)_right_x;
  byte _ry = (char)_right_y;
    
  
  RFsendProcess(SEND_SERIAL_ALL, 0x7f, 16,  Drone, Base,

                ((_roll & 0xff) | (_roll  & 0xff00)),
                ((_pitch & 0xff) | (_pitch  & 0xff00)),
                ((_yaw & 0xff) | (_yaw  & 0xff00)),
                
                ((_accX ) | (_accY  << 8)),
                ((_accZ) | (_lx << 8)),
                
                ((_ly) | (_rx << 8)),
                ((_ry) | (but << 8)),                
                ((micLV) | (batPercent<< 8))                           
                );     
}

void flightEvent(byte _event)
{
  RFsendProcess(SEND_SERIAL_SOFT, Command, 2, Controller, Drone, 0x07 | (_event << 8)); //command, length, _event
}

void moveBasedPowerAndRequestData(int _roll, int _pitch, int _yaw, int _throttle)
{
  RFsendProcess(SEND_SERIAL_SOFT, Control, 5, Controller, Drone, _roll | (_pitch << 8), _yaw | (_throttle << 8), 0xa0 ); //command, length
}

void moveBasedPower(int _roll, int _pitch, int _yaw, int _throttle)
{
  RFsendProcess(SEND_SERIAL_SOFT, Control, 4, Controller, Drone, _roll | (_pitch << 8), _yaw | (_throttle << 8) ); //command, length
}




void RFsendProcess(byte selectSerial, byte _cType, byte _length, byte _from, byte _to...)
{
  byte _data[50];
  byte _crc[2];

  _data[0] = _cType;
  _data[1] = (byte)_length;

  _data[2] = _from;
  _data[3] = _to;

  int index = 4;
  va_list ap;
  va_start(ap, _length);

  for (int i = 0; i < _length / 2; i++)
  {
    int _temp = va_arg(ap,  int);
    _data[index++] = _temp;
    _data[index++] = _temp >> 8;
  }

  if ((_length & 0x01) != 0)
  {
    int _temp = va_arg(ap,  int);
    _data[index++] = _temp;
  }

  va_end(ap); 

  //-------------------------------------------------------------------//
  unsigned short crcCal = CRC16_Make(_data, _length + 4);
  _crc[0] = (crcCal >> 8) & 0xff;
  _crc[1] = crcCal & 0xff;
  //-------------------------------------------------------------------//

  for (int i = _length + 5; i > 1 ; i--) _data[i] = _data[i - 2];

  _data[0] = 0x0A;
  _data[1] = 0x55;

  //CRC
  _data[_length + 6] = _crc[1];
  _data[_length + 7] = _crc[0];
 // _data[_length + 8] = 0xff;




	
	

	if(selectSerial == SEND_SERIAL_HW)
	{
		Serial.write(_data, _length + 8);  
	}
	else if(selectSerial == SEND_SERIAL_SOFT)
	{
		send_write(_data, _length + 8);
	}
	
	else if(selectSerial == SEND_SERIAL_ALL)
	{		
		
		if(_sendHWSerial == true)
		{
				Serial.write(_data, _length + 8);  
		}
		
		if(_sendSoftSerial == true)
		{
			send_write(_data, _length + 8);
		}	
		
		
	}	

}

//----------------------------------------------------------------------------------------//






//----------------------------------------------------------------------------------//
void BTstart()
{
  if (changeBaudrate == false)
  {
  //  SOFT_SERIAL.begin(BT_BAUDRATE);
    changeBaudrate = true;
    delay(100);
  }
}

void BTsendProcess(byte dataL, byte dataR, byte data)
{
  byte header1 = 0xaa;
  byte header2 = 0x55;
  byte _data[6];

  _data[0] = header1;
  _data[1] = header2;

  _data[2] = dataL;
  _data[3] = dataR;
  _data[4] = data;

  _data[5] = _data[2] + _data[3] + _data[4];
  Serial.write(_data, 6);
  send_write(_data, 6);
}
