//edit 200508

//#define OLED_USE
#define IRREMOTE_USE

//Sensor
#define FRONT_LEFT_LED  12
#define FRONT_RIGHT_LED 11
#define BACK_LEFT_LED   7
#define BACK_RIGHT_LED  8

#define RIGHT_FRONT_IR  1
#define LEFT_FRONT_IR   6

#define RIGHT_BOTTOM_IR 2
#define LEFT_BOTTOM_IR  4

#define RIGHT_REAR_IR   3
#define LEFT_REAR_IR    5

#define IR_EMIT_PIN 3

#define MUX_OUTPUT 21

#define MUX_S0 15
#define MUX_S1 16
#define MUX_S2 17
#define Z_LED 13

//battery
#define BATT_LVL_PIN 20

#define MIN_BATTERY_VOLTAGE 3.2
#define MAX_BATTERY_VOLTAGE 4.17

#define USB_VOLTAGE_DETECTED 1.7
#define USB_POWER_DETECTED 1    // only usb power "charging" (voltage < USB_VOLTAGE_DETECTED)
#define LOW_BATTERY_DETECTED 2  // low batt mode (USB_VOLTAGE_DETECTED < voltage < MIN_BATTERY_VOLTAGE )
#define GOOD_BATTERY_DETECTED 3 // battery detected and in working condition (voltage > MIN_BATTERY_VOLTAGE)

#define BUZZER_PIN 14

// PI Boot Control
#define ARD_PI_PIN 2

// the definition for rokit brick
#define YAW    1
#define PITCH  2
#define ROLL   3

#define ZUMI_LOGO  1
#define OPEN_EYES  2
#define CHARGING   3

#define FRONT_LEFT  1
#define FRONT_RIGHT 2
#define BACK_LEFT   3
#define BACK_RIGHT  4

//IR sensor
#define THE_FRONT_LEFT    6
#define THE_FRONT_RIGHT   1
#define THE_REAR_LEFT     5
#define THE_REAR_RIGHT    3
#define THE_BOTTOM_LEFT     4
#define THE_BOTTOM_RIGHT    2

#define WHOLE_NOTE   1000
#define HALF_NOTE     500
#define QUARTER_NOTE  250
#define EIGHTH_NOTE   125
#define SIXTEENTH_NOTE 62

#define ON  true
#define OFF false
#define buzzer TimerFreeTone

#define MAXVOLT 4.14
#define MINVOLT 3.45

#define BATTERY     1
#define IR_SENSOR   2
#define EULER_ANGLE 3
#define IR_REMOCON  4

//MOTOR
#define M1        1
#define M2        2

#define CW        1
#define CCW       2
#define STOP      3
#define LOOSE     4

#define FORWARD   1
#define BACKWARD  2
#define LEFT      5
#define RIGHT     6

#define forward   FORWARD
#define backward  BACKWARD

#define stop    STOP
#define loose   LOOSE

#define left    LEFT
#define right   RIGHT

//------------------------------------------------------------------------------------//
#define  CH1_KEY_U   0x80
#define  CH1_KEY_D   0x40
#define  CH1_KEY_L   0x20
#define  CH1_KEY_R   0x10
#define  CH1_KEY_C   0xF0
#define  CH1_KEY_F1  0x08
#define  CH1_KEY_F2  0x88
#define  CH1_KEY_F3  0x48
#define  CH1_KEY_F4  0xC8

#define  CH1_KEY_CH1  0x14
#define  CH1_KEY_CH2  0x15
#define  CH1_KEY_CH3  0x16
#define  CH1_KEY_CH4  0x17

#define  CH2_KEY_U   0x8D
#define  CH2_KEY_D   0x4D
#define  CH2_KEY_L   0x2D
#define  CH2_KEY_R   0x1D
#define  CH2_KEY_C   0xFD
#define  CH2_KEY_F1  0x04
#define  CH2_KEY_F2  0x84
#define  CH2_KEY_F3  0x44
#define  CH2_KEY_F4  0xC4

#define  CH2_KEY_CH1  0xE4
#define  CH2_KEY_CH2  0xE5
#define  CH2_KEY_CH3  0xE6
#define  CH2_KEY_CH4  0xE7

#define  CH3_KEY_U   0x83
#define  CH3_KEY_D   0x43
#define  CH3_KEY_L   0x23
#define  CH3_KEY_R   0x13
#define  CH3_KEY_C   0xF3
#define  CH3_KEY_F1  0x0C
#define  CH3_KEY_F2  0x8C
#define  CH3_KEY_F3  0x4C
#define  CH3_KEY_F4  0xCC

#define  CH3_KEY_CH1  0x64
#define  CH3_KEY_CH2  0x65
#define  CH3_KEY_CH3  0x66
#define  CH3_KEY_CH4  0x67

#define  CH4_KEY_U   0x8B
#define  CH4_KEY_D   0x4B
#define  CH4_KEY_L   0x2B
#define  CH4_KEY_R   0x1B
#define  CH4_KEY_C   0xFB
#define  CH4_KEY_F1  0x02
#define  CH4_KEY_F2  0x82
#define  CH4_KEY_F3  0x42
#define  CH4_KEY_F4  0xC2

#define  CH4_KEY_CH1  0xA4
#define  CH4_KEY_CH2  0xA5
#define  CH4_KEY_CH3  0xA6
#define  CH4_KEY_CH4  0xA7

#define  KEY_U       Zumi.Button_up
#define  KEY_D       Zumi.Button_down
#define  KEY_L       Zumi.Button_left
#define  KEY_R       Zumi.Button_right
#define  KEY_C       Zumi.Button_center
#define  KEY_F1      Zumi.Button_func1
#define  KEY_F2      Zumi.Button_func2
#define  KEY_F3      Zumi.Button_func3
#define  KEY_F4      Zumi.Button_func4
#define  KEY_CH1     Zumi.Button_ch1
#define  KEY_CH2     Zumi.Button_ch2
#define  KEY_CH3     Zumi.Button_ch3
#define  KEY_CH4     Zumi.Button_ch4



//------------------------------------------------------------------------------------//

//- timer0 = Pins 5, 6
//- timer1 = Pins 9, 10
//- timer2 = Pins 11, 3

#define MOTOR_LEFT_A  5
#define MOTOR_LEFT_B  6
#define MOTOR_RIGHT_A 10
#define MOTOR_RIGHT_B 9


// math function
#define ABS     1
#define CEILING 2
#define FLOOR   3
#define SQRT    4
#define SIN     5
#define COS     6
#define TAN     7
#define ASIN    8
#define ACOS    9
#define ATAN   10
#define LN     11
#define LOG    12
#define EXP    13
#define E10    14



//OLED.h
#if  defined(OLED_USE)
  //Library for the OLED
  #include "U8glib.h"
  //I am using the I2C one so select the following class
  U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE);
  //U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE | U8G_I2C_OPT_DEV_0);

#endif

//GYRO
// I2Cdev and MPU6050 must be installed as libraries, or else the .cpp/.h files
// for both classes must be in the include path of your project
#include "I2Cdev.h"
#include "MPU6050_6Axis_MotionApps20.h"
#if I2CDEV_IMPLEMENTATION == I2CDEV_ARDUINO_WIRE
  #include "Wire.h"
#endif

//irremocon
#if defined(IRREMOTE_USE)
 //Infrared Remote Library
  #include <IRremote.h>
  #define IR_REMREC_PIN 4
  IRrecv irrecv(IR_REMREC_PIN);
  decode_results results;
#endif

#include "math.h"
#include "pitches.h"

MPU6050 mpu;


#if defined(OLED_USE)

// Image data for Zumi's opened eyes
static const unsigned char PROGMEM opened_eyes[] =
{
  B01100000, B00000000, B00111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111100, B00000000, B00000110,
  B01100000, B00000011, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000111, B11111111, B11000000, B00001110,
  B01111000, B00001111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00011111, B11111111, B11110000, B00011110,
  B01111110, B00111111, B11111111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11111111, B11111100, B01111110,
  B01111111, B11111111, B11111111, B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111111, B11111111, B11111111, B11111110,
  B01111111, B11111111, B11111111, B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11111111, B11111111, B11111111, B11111110,
  B01111111, B11111111, B11111111, B11111111, B11000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000011, B11111111, B11111111, B11111111, B11111110,
  B01111111, B11111111, B11111111, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000111, B11111111, B11111111, B11111111, B11111110,
  B01111111, B11111111, B11111111, B11111111, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B11111111, B11111111, B11111111, B11111110,
  B01111111, B11111111, B11111111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00011111, B11111111, B11111111, B11111111, B11111100,
  B00111111, B11111111, B11111111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00011111, B11111111, B11111111, B11111111, B11111100,
  B00111111, B11111111, B11111111, B11111111, B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11111111, B11111111, B11111111, B11111000,
  B00111111, B11111111, B11111111, B11111111, B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11111111, B11111111, B11111111, B11111100,
  B00111111, B11111111, B11111000, B00000111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11110000, B00001111, B11111111, B11111100,
  B00111111, B11111111, B11000000, B00000001, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11000000, B00000001, B11111111, B11111110,
  B01111111, B11111111, B00000000, B00000000, B01111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111111, B00000000, B00000000, B11111111, B11111110,
  B01111111, B11111110, B00001111, B11000000, B00011111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111100, B00011111, B10000000, B00111111, B11111110,
  B01111111, B11111100, B01111111, B11111000, B00001111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111000, B11111111, B11110000, B00011111, B11111110,
  B11111111, B11111000, B11111111, B11111100, B00000111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11110001, B11111111, B11111000, B00001111, B11111111,
  B11111111, B11110001, B11111111, B11111100, B00000011, B10000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11100011, B11111111, B11111100, B00000111, B11111111,
  B11111111, B11100011, B11111111, B11111100, B00000001, B10000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11000111, B11111111, B11111100, B00000011, B11111111,
  B11111111, B11000111, B11111111, B11111100, B00000001, B10000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11000111, B11111111, B11111000, B00000001, B11111111,
  B11111111, B11000111, B11111111, B11111000, B00000000, B10000000, B00000000, B00000000, B00000000, B00000000, B00000001, B10001111, B11111111, B11110000, B00000001, B11111111,
  B11111111, B10001111, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000001, B00001111, B11111111, B11000000, B00000000, B11111111,
  B11111111, B10001111, B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000001, B00001111, B11111110, B00000000, B00000000, B11111111,
  B11111111, B00001111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B11111000, B00000000, B00000000, B01111111,
  B11111111, B00001111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B11000000, B00000000, B00000000, B01111111,
  B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111,
  B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111,
  B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111,
  B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111,
  B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111111,
  B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11111111,
  B11111111, B11000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B10000000, B00000000, B00000000, B00000001, B11111111,
  B01111111, B11000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B10000000, B00000000, B00000000, B00000001, B11111110,
  B01111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000011, B11111110,
  B01111111, B11110000, B00000000, B00000000, B00000010, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01100000, B00000000, B00000000, B00000111, B11111110,
  B00111111, B11110000, B00000000, B00000000, B00000110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01110000, B00000000, B00000000, B00001111, B11111100,
  B00111111, B11111000, B00000000, B00000000, B00001110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111000, B00000000, B00000000, B00011111, B11111100,
  B00011111, B11111110, B00000000, B00000000, B00011100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111100, B00000000, B00000000, B00111111, B11111000,
  B00011111, B11111111, B00000000, B00000000, B00111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111110, B00000000, B00000000, B01111111, B11111000,
  B00001111, B11111111, B11000000, B00000000, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00011111, B10000000, B00000001, B11111111, B11110000,
  B00000111, B11111111, B11110000, B00000011, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B11100000, B00000111, B11111111, B11100000,
  B00000111, B11111111, B11111111, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000111, B11111111, B11111111, B11111111, B11100000,
  B00000011, B11111111, B11111111, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000111, B11111111, B11111111, B11111111, B11000000,
  B00000001, B11111111, B11111111, B11111111, B11000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000011, B11111111, B11111111, B11111111, B10000000,
  B00000000, B11111111, B11111111, B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11111111, B11111111, B11111111, B00000000,
  B00000000, B01111111, B11111111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11111111, B11111110, B00000000,
  B00000000, B00011111, B11111111, B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11111111, B11111000, B00000000,
  B00000000, B00000111, B11111111, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B11111111, B11100000, B00000000,
  B00000000, B00000000, B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000001, B11111111, B00000000, B00000000
};

// Image data for Zumi's closed eyes
static const unsigned char PROGMEM zumi_logo_fullsize[] =
{
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000111, B11111111, B11111111, B10000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B10000000,
  B00000111, B11111111, B11111111, B11100000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11000000,
  B00000111, B11111111, B11111111, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11100000,
  B00000111, B11111111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11100000,
  B00000111, B11111111, B11111111, B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11100000,
  B00000111, B11111111, B11111111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11100000,
  B00000111, B11111111, B11111111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11100000,
  B00000111, B11111111, B11111111, B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11000000,
  B00000111, B11111111, B11111111, B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00011111, B11000000,
  B00000000, B00000000, B00000111, B11111111, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00001111, B00000000,
  B00000000, B00000000, B00000111, B11111111, B00000000, B01111000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00001111, B11111111, B00000001, B11111100, B00000011, B11000000, B00000000, B00111111, B11110000, B00001111, B11111100, B00000000, B00111111, B11100000,
  B00000000, B00000000, B00011111, B11111110, B00001111, B11111110, B00000111, B11110000, B00000000, B11111111, B11111100, B00111111, B11111111, B00000000, B00111111, B11100000,
  B00000000, B00000000, B01111111, B11111110, B00000111, B11111111, B00001111, B11111010, B00000011, B11111111, B11111111, B11111111, B11111111, B10000000, B00111111, B11100000,
  B00000000, B00000000, B11111111, B11111110, B00000011, B11111111, B00001111, B11111110, B00000111, B11111111, B11111111, B11111111, B11111111, B11100000, B00111111, B11100000,
  B00000000, B00000001, B11111111, B11111100, B00000011, B11111111, B00011111, B11111110, B00001111, B11111111, B11111111, B11111111, B11111111, B11100000, B00111111, B11100000,
  B00000000, B00000111, B11111111, B11111000, B00000011, B11111111, B00011111, B11111000, B00001111, B11111111, B11111111, B11111111, B11111111, B11110000, B00111111, B11100000,
  B00000000, B00001111, B11111111, B11110000, B00000011, B11111110, B00001111, B11111000, B00011111, B11111111, B11111111, B11111111, B11111111, B11111000, B00111111, B11100000,
  B00000000, B00011111, B11111111, B11100000, B00000001, B11111110, B00001111, B11111000, B00111111, B11111111, B11111111, B11111111, B11111111, B11111000, B00111111, B11100000,
  B00000000, B01111111, B11111111, B10000000, B00000000, B11111000, B00000111, B11110000, B00111111, B11111111, B11111111, B11111111, B11111111, B11111100, B00111111, B11100000,
  B00000000, B11111111, B11111111, B00000000, B00000000, B00000000, B00000011, B11100000, B00111111, B11111000, B01111111, B11111111, B00111111, B11111100, B00111111, B11100000,
  B00000001, B11111111, B11111110, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11110000, B00111111, B11111100, B00001111, B11111100, B00111111, B11100000,
  B00000011, B11111111, B11111100, B00000000, B00000000, B00000000, B00000000, B00000000, B00111111, B11110000, B00011111, B11111000, B00001111, B11111100, B00111111, B11100000,
  B00000011, B11111111, B11110000, B00000000, B00011111, B11110000, B00000000, B00000000, B01111111, B11100000, B00011111, B11111000, B00000111, B11111110, B00111111, B11100000,
  B00000111, B11111111, B11100000, B00000000, B00011111, B11110000, B00000111, B10000000, B01111111, B11100000, B00011111, B11111000, B00000111, B11111110, B00111111, B11100000,
  B00000111, B11111111, B11000000, B00000000, B00011111, B11111000, B00001111, B11111100, B01111111, B11100000, B00011111, B11111000, B00000111, B11111110, B00111111, B11100000,
  B00000111, B11111111, B00000000, B00000000, B00011111, B11111000, B00001111, B11111100, B01111111, B11100000, B00011111, B11111000, B00000111, B11111110, B00111111, B11100000,
  B00000111, B11111110, B00000000, B00000000, B00011111, B11111100, B00111111, B11111100, B01111111, B11100000, B00011111, B11111000, B00000111, B11111110, B01111111, B11100000,
  B00000111, B11111111, B11111111, B11111110, B00011111, B11111111, B11111111, B11111100, B01111111, B11100000, B00011111, B11111000, B00000111, B11111111, B11111111, B11100000,
  B00000111, B11111111, B11111111, B11111111, B00001111, B11111111, B11111111, B11111000, B01111111, B11100000, B00011111, B11111000, B00000111, B11111111, B11111111, B11100000,
  B00000111, B11111111, B11111111, B11111111, B00001111, B11111111, B11111111, B11111000, B01111111, B11100000, B00011111, B11111000, B00000011, B11111111, B11111111, B11100000,
  B00000111, B11111111, B11111111, B11111111, B00000111, B11111111, B11111111, B11110000, B01111111, B11100000, B00011111, B11111000, B00000011, B11111111, B11111111, B11000000,
  B00000011, B11111111, B11111111, B11111111, B00000111, B11111111, B11111111, B11100000, B01111111, B11100000, B00011111, B11111000, B00000001, B11111111, B11111111, B11000000,
  B00000011, B11111111, B11111111, B11111111, B00000011, B11111111, B11111111, B11100000, B01111111, B11100000, B00011111, B11111000, B00000001, B11111111, B11111111, B10000000,
  B00000001, B11111111, B11111111, B11111111, B00000001, B11111111, B11111111, B11000000, B01111111, B11100000, B00011111, B11111000, B00000000, B11111111, B11111111, B00000000,
  B00000000, B11111111, B11111111, B11111111, B00000000, B01111111, B11111111, B00000000, B01111111, B11100000, B00011111, B11111000, B00000000, B01111111, B11111110, B00000000,
  B00000000, B00111111, B11111111, B11111111, B00000000, B00011111, B11111100, B00000000, B01111111, B11100000, B00011111, B11111000, B00000000, B00011111, B11111000, B00000000,
  B00000000, B00000111, B11111111, B11111110, B00000000, B00000011, B11100000, B00000000, B00111111, B11100000, B00001111, B11110000, B00000000, B00000011, B11000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000
};

static const unsigned char PROGMEM zumi_charging_fullsize[] =
{
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11111111, B11111111, B11111111, B11111111, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11111111, B11111111, B11111111, B11111111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011110, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011111, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011111, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011110, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B11111111, B11111111, B11111111, B11111111, B11111111, B11111000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B01111111, B11111111, B11111111, B11111111, B11111111, B11110000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000
};


static const unsigned char PROGMEM zumi_charging_minisize[] =
{
  B00000000, B01111111, B11111111, B11111111, B11111111, B11111111, B11110000, B00000000,
  B00000000, B11111111, B11111111, B11111111, B11111111, B11111111, B11111000, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011110, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011111, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00000011, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011111, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011110, B00000000,
  B00000000, B11000000, B00000000, B00000000, B00000000, B00000000, B00011000, B00000000,
  B00000000, B11111111, B11111111, B11111111, B11111111, B11111111, B11111000, B00000000,
  B00000000, B01111111, B11111111, B11111111, B11111111, B11111111, B11110000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000000, B01100001, B00000000, B00000000, B00000000, B00100000, B00000000, B00000000,
  B00000001, B10011001, B00000000, B00000000, B00000000, B00100000, B00000000, B00000000,
  B00000010, B00001001, B00000000, B00000000, B00000000, B00000000, B00000000, B00000000,
  B00000100, B00000001, B11110001, B11111011, B10011111, B00100111, B11000111, B11000000,
  B00000100, B00000001, B10011010, B00011010, B00100001, B00100100, B01001000, B01000000,
  B00000100, B00000001, B00001010, B00001010, B00100001, B00100100, B01001000, B01000000,
  B00000100, B00000001, B00001010, B00001010, B00100001, B00100100, B01001000, B01000000,
  B00000010, B00001001, B00001011, B00011010, B00100001, B00100100, B01001000, B01000000,
  B00000001, B10011001, B00001001, B11111010, B00011111, B00100100, B01000111, B11000000,
  B00000000, B11100000, B00000000, B00000000, B00000001, B00000000, B00000000, B01000000,
  B00000000, B00000000, B00000000, B00000000, B00110011, B00000000, B00001100, B11000000,
  B00000000, B00000000, B00000000, B00000000, B00001100, B00000000, B00000011, B00000000,
};

#endif

class ZumiClass
{

  public:

    ZumiClass()
    {
      //--------------------------------//
      // Do not run PI's boot script
      pinMode(ARD_PI_PIN, OUTPUT);
      digitalWrite(ARD_PI_PIN, HIGH);
      //--------------------------------//

      devStatus = 0;
      offset = 3;
      decBL = 0;
      decBR = 0;
      baseBL = 1023;
      baseBR = 1023;

      firstRun = true;
      //xbuf[10] = {};
      n = 0;
    }

    int math(char op, int num);
    void IRsensorInit();
    void LEDInit();
    void ledTEST();
    void LEDOnOff(int led, boolean onOff);
    byte readIR(int indexOfIRSensor, bool emitterOn);

    double checkBattery();
    void TimerFreeTone(uint8_t pin, unsigned long frequency, unsigned int duration, uint8_t volume = 10);
    int readIRreceiver();
    void startIRreceiver();
    float eulerAngle(int euler);
    void OLED_ChargingAnimation();
    void OLED_EyeAnimation();
    void OLED_Clear();
    void OLED_ZumiLOGO();
    void OLEDAnimation(int dp);
    //void eulerAngle(int euler);
    void GyroInit();
    void gyroSensorIRinit();
    void gyroSensorForward(int speed);
    boolean getGyro();

    void MotorInit();
    void DCMotor(char SelectMotor, char direction, char speed);
    void DCMove(byte direction, byte speed);
    void OLEDOutput(int sel);

    float ypr[3];              // [yaw, pitch, roll]   yaw/pitch/roll container and gravity vecto


	unsigned char Button_up;
	unsigned char Button_down;
	unsigned char Button_left;
	unsigned char Button_right;
	unsigned char Button_center;
	unsigned char Button_func1;
	unsigned char Button_func2;
	unsigned char Button_func3;
	unsigned char Button_func4;
	unsigned char Button_ch1;
	unsigned char Button_ch2;
	unsigned char Button_ch3;
	unsigned char Button_ch4;


	void setIRChannel(int _ch);


	void GyroCalibrationProcess(int tuneCount = 1);
	void GyroCalibration();

	void delayForGyro(float time);


		// for moveContinuousCircle
		int currentAngle = 0;
		unsigned long prevTime = 0;

		// for PID
		int MAX_USER_SPEED = 80;
		double error_sum = 0;
		double error_past = 0;
		unsigned long PID_time_past = micros();




		void moveForward(float time = 1, int speed = 60, float newAngle = 0);
		void moveBackward(float time = 1, int speed = 60, float newAngle = 0);

		void moveTurn(int direction, float newAngle, int speed = 60);

		void moveContinuousAngle(int speed = 60, float newAngle = 0);

  	void moveCircle(int direction, int speed, int step, float interval = 0.01);
		void moveContinuousCircle(int direction, int speed, int step, float interval = 0.01);

		void moveAcrossBlocks(int block , int threshold = 125, float newAngle = 9999);
    void moveAcrossBlocksForwardDetection(int threshold = 125, int forwardDetection = 0, float newAngle = 9999);



		void MoveProcessForGyro(int max_speed, double base_speed, double desired_angle, double k_p, double k_d, double k_i, double min_error, int dir);







  private:
    int BatteryStatusCheck();
    long readVccMilliVolts();
    byte batteryPercentage(double batteryVoltage);
    void SoundProcess(int _melody[], int _tempo[], int _size);
    float map(float x, float in_min, float in_max, float out_min, float out_max);
    float movAvgFilter(float x);
    void OLEDIRRemocon();
    void OLEDYPROutput();
    void OLEDIRSensor();
    void OLEDBattery();

    double batteryVoltage;
    bool chargeOnlyMode;
    byte chargingState;

    uint8_t mpuIntStatus;     // holds actual interrupt status byte from MPU
    uint8_t devStatus;        // return status after each device operation (0 = success, !0 = error)
    uint16_t packetSize;      // expected DMP packet size (default is 42 bytes)
    uint16_t fifoCount;       // count of all bytes currently in FIFO
    uint8_t fifoBuffer[64];   // FIFO storage buffer
    Quaternion q;             // [w, x, y, z]         quaternion container
    VectorFloat gravity;      // [x, y, z]            gravity vector


	int16_t setXAccelOffset;
	int16_t setYAccelOffset;
	int16_t setZAccelOffset;

	int16_t setXGyroOffset;
	int16_t setYGyroOffset;
	int16_t setZGyroOffset;


    float targetAngle;
    float nowAngle;
    int moveFlag;
    int offset;
    byte decBL, decBR;
    int  baseBL, baseBR;

    float boxWidth;
    boolean firstRun;
    float xbuf[10];
    int n;
};


int ZumiClass::math(char op, int num)
{
    int result = 0;
       switch(op){
        case ABS:
            result = abs(num);
            break;
        case CEILING:
            result = ceil(num);
            break;
        case FLOOR:
            result = floor(num);
            break;
        case SQRT:
            result = sqrt(num);
            break;
        case SIN:
            result = sin(num * DEG_TO_RAD);
            break;
        case COS:
            result = cos(num * DEG_TO_RAD);
            break;
        case TAN:
            result = tan(num * DEG_TO_RAD);
            break;
        case ASIN:
            result = RAD_TO_DEG * (asin(num));
            break;
        case ACOS:
            result = RAD_TO_DEG * (acos(num));
            break;
        case ATAN:
            result = RAD_TO_DEG * (atan(num));
            break;
        case LN:
            result = log(num);
            break;
       case LOG:
            result = log10(num);
            break;
       case EXP:
            result = exp(num);
            break;
       case  E10:
            result = pow(10,num);
            break;
       default:
           result = 0;
           break;
    }
     return result;
}


void ZumiClass::IRsensorInit()
{
  // Setup analog pins for multiplexer as output
  pinMode(MUX_S0, OUTPUT);
  pinMode(MUX_S1, OUTPUT);
  pinMode(MUX_S2, OUTPUT);

  // IR LEDs transistor control
  pinMode(IR_EMIT_PIN, OUTPUT);

  digitalWrite(IR_EMIT_PIN, LOW);
}

void ZumiClass::LEDInit()
{
  // LED setup
  pinMode(FRONT_RIGHT_LED, OUTPUT);
  pinMode(FRONT_LEFT_LED, OUTPUT);
  pinMode(BACK_RIGHT_LED, OUTPUT);
  pinMode(BACK_LEFT_LED, OUTPUT);
  pinMode(Z_LED, OUTPUT);
}

void ZumiClass::ledTEST()
{
  digitalWrite(FRONT_LEFT_LED, HIGH);
  delay(100);
  digitalWrite(FRONT_LEFT_LED, LOW);

  delay(100);
  digitalWrite(FRONT_RIGHT_LED, HIGH);
  delay(100);
  digitalWrite(FRONT_RIGHT_LED, LOW);

  delay(100);
  digitalWrite(BACK_LEFT_LED, HIGH);
  delay(100);
  digitalWrite(BACK_LEFT_LED, LOW);

  delay(100);
  digitalWrite(BACK_RIGHT_LED, HIGH);
  delay(100);
  digitalWrite(BACK_RIGHT_LED, LOW);
}

byte ZumiClass::readIR(int indexOfIRSensor, bool emitterOn)
{
  // Select different channels on the Multiplexer
  switch (indexOfIRSensor)
  {
    //--------------------------------------
    case 0:
      //000 = 0
      digitalWrite(15, LOW);
      digitalWrite(16, LOW);
      digitalWrite(17, LOW);
      break;
    //--------------------------------------
    case 1://Y1 rightFrontIR
      //001 = 1
      digitalWrite(15, HIGH);
      digitalWrite(16, LOW);
      digitalWrite(17, LOW);
      break;
    //--------------------------------------
    case 2://Y2 rightBottomIR
      //010 = 2
      digitalWrite(15, LOW);
      digitalWrite(16, HIGH);
      digitalWrite(17, LOW);
      break;
    //--------------------------------------
    case 3://Y3 rightRearIR
      //011 = 3
      digitalWrite(15, HIGH);
      digitalWrite(16, HIGH);
      digitalWrite(17, LOW);
      break;
    //--------------------------------------
    case 4://Y4 leftBottomIR
      //100 = 4
      digitalWrite(15, LOW);
      digitalWrite(16, LOW);
      digitalWrite(17, HIGH);
      break;
    //--------------------------------------
    case 5://Y5 leftRearIR
      //101 = 5
      digitalWrite(15, HIGH);
      digitalWrite(16, LOW);
      digitalWrite(17, HIGH);
      break;
    //--------------------------------------
    case 6://Y6 leftFrontIR
      //110 = 6
      digitalWrite(15, LOW);
      digitalWrite(16, HIGH);
      digitalWrite(17, HIGH);
      break;
    //--------------------------------------
    case 7://Y7
      //111 = 7
      digitalWrite(15, HIGH);
      digitalWrite(16, HIGH);
      digitalWrite(17, HIGH);
      break;
    //--------------------------------------
    default:
      break;
  }

  if (emitterOn) digitalWrite(IR_EMIT_PIN, HIGH);
  else digitalWrite(IR_EMIT_PIN, LOW);

  delayMicroseconds(100);  // Allow the voltage to rise a bit after switching on the multiplexer
//  delayMicroseconds(80);  // Allow the voltage to rise a bit after switching on the multiplexer

  byte value = analogRead(MUX_OUTPUT) / 4;  // Reduce voltage to a value between 0-255 for sending over I2C

  digitalWrite(IR_EMIT_PIN, LOW);

  return value;
}


int ZumiClass::BatteryStatusCheck()
{
  // Get initial battery reading
  batteryVoltage = checkBattery();

  //--------------------------------------------//
 // Serial.println(batteryVoltage);
  //--------------------------------------------//

  // ?�원??켜질??3.2v ?�상 ?�압??경우
  //If the battery level is above 3.2 volts
  if (batteryVoltage > MIN_BATTERY_VOLTAGE)//battery at functioning voltage
  {
    /*
    Serial.println(1);
    Serial.println("GOOD_BATTERY_DETECTED");
    Serial.println("chargeOnlyMode : false");
    */
    //  sound_1();

    chargeOnlyMode = false;
    chargingState = GOOD_BATTERY_DETECTED;

    //  zumi_LogoBlink();
    // display.display();
    // delay(3000);
  }


  // ?�원??켜질??1.7v ?�상?�고 ?�압??경우 3.2v ?�하 ??경우
  else if (batteryVoltage > USB_VOLTAGE_DETECTED && batteryVoltage < MIN_BATTERY_VOLTAGE)
  {
/*
    Serial.println(2);
    Serial.println("LOW_BATTERY_DETECTED");
    Serial.println("chargeOnlyMode : false");
    */
    //    sound_2();

    //battery is low
    chargeOnlyMode = false;
    chargingState = LOW_BATTERY_DETECTED;
  }


  else
  {
    // - USB��??�결?�고 배터��??�태
    /*
    Serial.println(3);
    Serial.println("USB_POWER_DETECTED");
    Serial.println("chargeOnlyMode : true");
    */
    //  sound_3();

    //USB connected
    chargeOnlyMode = true;
    chargingState = USB_POWER_DETECTED;
    /*
        display.drawBitmap(0, 0, zumi_charging_fullsize, 128, 64, 1);
        display.setTextSize(1);
        display.setCursor(38, 55);
        display.print(F("USB "));

        //display voltage of input USB
        display.print(checkInputVCC());
        display.print(F("V"));
        display.display();
        display.clearDisplay();
    */
    //  delay(3000);
  }
  return chargeOnlyMode;
}

byte ZumiClass::batteryPercentage(double batteryVoltage)
{
  byte battPercent = 0;

  //int MIN_BATTERY_VOLTAGE = 3.2
  //int MAX_BATTERY_VOLTAGE = 4.17
  //Each battery will reach different max voltages.
  //For example: 4.17, 4.20.

  if (batteryVoltage > MIN_BATTERY_VOLTAGE) battPercent = (batteryVoltage - MIN_BATTERY_VOLTAGE) / (MAX_BATTERY_VOLTAGE - MIN_BATTERY_VOLTAGE) * 100;

  // Make sure values such as 109% are not shown
  if (battPercent > 100)   battPercent = 100;
  else if (battPercent < 0)    battPercent = 0;

  return battPercent;
}


double ZumiClass::checkBattery()
{
  double bitsPerVolts = 1023.0 / (readVccMilliVolts() * 0.001);
  return analogRead(BATT_LVL_PIN) /  ( bitsPerVolts);
}
/*
double checkInputVCC()
{
  //If the Vcc rail = 5v then this value should equal 5 volts
  double vcc =  (readVccMilliVolts() * 0.001) ;
  return vcc;
}
*/
long ZumiClass::readVccMilliVolts()
{
  long result;
  // Read 1.1V reference against AVcc
  ADMUX = _BV(REFS0) | _BV(MUX3) | _BV(MUX2) | _BV(MUX1);
  delay(2);             // Wait for Vref to settle
  ADCSRA |= _BV(ADSC);  // Convert
  while (bit_is_set(ADCSRA, ADSC));
  result = ADCL;
  result |= ADCH << 8;
  result = 1126400L / result; // Back-calculate AVcc in mV
  return result;
}

void ZumiClass::SoundProcess(int _melody[], int _tempo[], int _size)
{
  for (int thisNote = 0; thisNote < _size; thisNote++)
  {
    int noteDuration = 1000 / _tempo[thisNote];

    TimerFreeTone(BUZZER_PIN, _melody[thisNote], noteDuration);
    //tone(BUZZER_PIN, _melody[thisNote], noteDuration);
    int pauseBetweenNotes = noteDuration * 1.30;
    delay(pauseBetweenNotes);
  }
}

void ZumiClass::TimerFreeTone(uint8_t pin, unsigned long frequency, unsigned int duration, uint8_t volume)
{

  uint8_t _tft_volume[] = { 255, 200, 150, 125, 100, 87, 50, 33, 22, 2 }; // Duty for linear volume control.

  if (frequency == 0 || volume == 0)
  {
    delay(duration);
    return;
  }
  frequency = 1000000 / frequency;                              // Calculate the square wave length (in microseconds).
  uint32_t duty = frequency / _tft_volume[min(volume, 10) - 1]; // Calculate the duty cycle (volume).
  uint8_t pinBit = digitalPinToBitMask(pin);                                  // Get the bitmask for the pin.
  volatile uint8_t *pinOutput = (uint8_t *) portOutputRegister(digitalPinToPort(pin)); // Get the port register for the pin.
  volatile uint8_t *portMode = (uint8_t *) portModeRegister(digitalPinToPort(pin));    // Get the port mode register for the pin.
  *portMode |= pinBit;                                                        // Set pin to output mode.

  uint32_t startTime = millis();           // Starting time of note.
  while (millis() - startTime < duration)
  { // Loop for the duration.
    *pinOutput |= pinBit;    // Set pin high.
    delayMicroseconds(duty); // Square wave duration (how long to leave pin high).
    *pinOutput &= ~pinBit;   // Set pin low.
    delayMicroseconds(frequency - duty); // Square wave duration (how long to leave pin low).
  }
}

void ZumiClass::GyroInit()
{

  // join I2C bus (I2Cdev library doesn't do this automatically)
#if I2CDEV_IMPLEMENTATION == I2CDEV_ARDUINO_WIRE
  Wire.begin();
  Wire.setClock(400000); // 400kHz I2C clock. Comment this line if having compilation difficulties
#elif I2CDEV_IMPLEMENTATION == I2CDEV_BUILTIN_FASTWIRE
  Fastwire::setup(400, true);
#endif

  mpu.initialize();
  //Serial.println(mpu.testConnection() ? F("MPU6050 connection successful") : F("MPU6050 connection failed"));
  devStatus = mpu.dmpInitialize();

  // supply your own gyro offsets here, scaled for min sensitivity
  // Apply calibration value
  mpu.setXAccelOffset(setXAccelOffset);
  mpu.setYAccelOffset(setYAccelOffset);
  mpu.setZAccelOffset(setZAccelOffset);

  mpu.setXGyroOffset(setXGyroOffset);
  mpu.setYGyroOffset(setYGyroOffset);
  mpu.setZGyroOffset(setZGyroOffset);

  if (devStatus == 0) // make sure it worked (returns 0 if so)
  {
    //   Serial.println(F("Enabling DMP...")); // turn on the DMP, now that it's ready
    mpu.setDMPEnabled(true);
    mpuIntStatus = mpu.getIntStatus();
    // set our DMP Ready flag so the main loop() function knows it's okay to use it
    // Serial.println(F("DMP ready! Waiting for first interrupt..."));
    packetSize = mpu.dmpGetFIFOPacketSize();  // get expected DMP packet size for later comparison
  }
  else
  {
    // ERROR!
    // 1 = initial memory load failed
    // 2 = DMP configuration updates failed
    // (if it's going to break, usually the code will be 1)
    Serial.print(F("DMP Initialization failed (code "));
    Serial.print(devStatus);
    Serial.println(F(")"));
  }
}

void ZumiClass::gyroSensorIRinit()
{
  TIMSK2 &= ~(1 << TOIE2);

  for (int i = 0; i < 100; i++)
  {
    baseBL  = min(readIR(RIGHT_BOTTOM_IR, true), baseBL) + 50;
    baseBR  = min(readIR(LEFT_BOTTOM_IR, true), baseBR) + 50;
  }
}


void ZumiClass::gyroSensorForward(int speed)
{
  //----------------------------------------------//

 if (moveFlag == 0)   moveFlag = 1;

    else if (moveFlag == 1)
    {
      nowAngle = ypr[0] * 180 / M_PI;
      targetAngle = nowAngle;
      moveFlag++;
      DCMove(forward, 60);
    }

    else if (moveFlag == 2)
    {
      if (readIR(RIGHT_BOTTOM_IR, true) > baseBL)  decBL = 1;
      else  decBL = 0;

      if (readIR(LEFT_BOTTOM_IR, true) > baseBR)  decBR = 1;
      else  decBR = 0;

      if  ((!decBL) or (!decBR))    // 검?�?�을 만날 ?�까지 직진
      {
        //--------------------------------------------------//
        nowAngle = ypr[0] * 180 / M_PI;

        if (nowAngle < targetAngle - offset)
        {
          DCMotor(M1, CCW, 120);
          DCMotor(M2, STOP, 60);
        }
        else if (nowAngle > targetAngle + offset)
        {
          DCMotor(M1, STOP, 120);
          DCMotor(M2, CW, 60);
        }
        else   DCMove(forward, 60);
        //--------------------------------------------------//
      }
      else  moveFlag++;
    }
    else if (moveFlag == 3)   DCMove(stop, 0);


  while (fifoCount < packetSize)
  {
    if (fifoCount < packetSize)
    {
      fifoCount = mpu.getFIFOCount(); // try to get out of the infinite loop
    }
  }
  mpuIntStatus = mpu.getIntStatus(); // reset interrupt flag and get INT_STATUS byte
  fifoCount = mpu.getFIFOCount();    // get current FIFO count
  // check for overflow (this should never happen unless our code is too inefficient)
  if ((mpuIntStatus & _BV(MPU6050_INTERRUPT_FIFO_OFLOW_BIT)) || fifoCount >= 1024)
  {
    mpu.resetFIFO();  // reset so we can continue cleanly
    fifoCount = mpu.getFIFOCount();
   // Serial.println(F("FIFO overflow!"));
    // otherwise, check for DMP data ready interrupt (this should happen frequently)
  }
  else if (mpuIntStatus & _BV(MPU6050_INTERRUPT_DMP_INT_BIT))
  {
    // wait for correct available data length, should be a VERY short wait
    while (fifoCount < packetSize) fifoCount = mpu.getFIFOCount();
    mpu.getFIFOBytes(fifoBuffer, packetSize); // read a packet from FIFO
    // track FIFO count here in case there is > 1 packet available
    // (this lets us immediately read more without waiting for an interrupt)
    fifoCount -= packetSize;
    // display Euler angles in degrees
    mpu.dmpGetQuaternion(&q, fifoBuffer);
    mpu.dmpGetGravity(&gravity, &q);
    mpu.dmpGetYawPitchRoll(ypr, &q, &gravity);
  }
  //----------------------------------------------//
}

float ZumiClass::eulerAngle(int euler) {
  if(euler == YAW) return (ypr[0] * 180) / M_PI ;
  else if(euler == PITCH) return (ypr[1] * 180) / M_PI;
  else if(euler == ROLL) return (ypr[2] * 180) / M_PI;
  else return 0;
}

void ZumiClass::GyroCalibration()
{
  GyroCalibrationProcess(1);
  GyroInit();
  delay(20);
}

void ZumiClass::GyroCalibrationProcess(int tuneCount = 1)
{

#if I2CDEV_IMPLEMENTATION == I2CDEV_ARDUINO_WIRE
  Wire.begin();
#elif I2CDEV_IMPLEMENTATION == I2CDEV_BUILTIN_FASTWIRE
  Fastwire::setup(400, true);
#endif

  mpu.initialize();

  // Serial.println("PID tuning Each Dot = 100 readings");
  mpu.CalibrateAccel(tuneCount);
  mpu.CalibrateGyro(tuneCount);

  uint8_t devAddr = 0x68;
  uint8_t AOffsetRegister = (mpu.getDeviceID() < 0x38 ) ? MPU6050_RA_XA_OFFS_H : 0x77;
  int16_t Data[3];

  if (AOffsetRegister == 0x06) I2Cdev::readWords(devAddr, AOffsetRegister, 3, (uint16_t *)Data);
  else {
    I2Cdev::readWords(devAddr, AOffsetRegister, 1, (uint16_t *)Data);
    I2Cdev::readWords(devAddr, AOffsetRegister + 3, 1, (uint16_t *)Data + 1);
    I2Cdev::readWords(devAddr, AOffsetRegister + 6, 1, (uint16_t *)Data + 2);
  }

  setXAccelOffset = Data[0];
  setYAccelOffset = Data[1];
  setZAccelOffset = Data[2];

  I2Cdev::readWords(devAddr, 0x13, 3, (uint16_t *)Data);

  setXGyroOffset = Data[0];
  setYGyroOffset = Data[1];
  setZGyroOffset = Data[2];

}


boolean ZumiClass::getGyro()
{
  boolean success = false;

  // get current FIFO count
  fifoCount = mpu.getFIFOCount();

  // check for overflow (this should never happen unless our code is too inefficient)
  if (fifoCount == 1024)
  {
    // reset so we can continue cleanly
    mpu.resetFIFO();
   // Serial.println(F("FIFO overflow!"));
    // otherwise, check for DMP data ready interrupt (this should happen frequently)
  }
  else
  {
    while(fifoCount >= packetSize){ // Lets catch up to NOW, someone is using the dreaded delay()!
	mpu.getFIFOBytes(fifoBuffer, packetSize);
	// track FIFO count here in case there is > 1 packet available
	// (this lets us immediately read more without waiting for an interrupt)
	fifoCount -= packetSize;
    }

    // display Euler angles in degrees
    mpu.dmpGetQuaternion(&q, fifoBuffer);
    mpu.dmpGetGravity(&gravity, &q);
    mpu.dmpGetYawPitchRoll(ypr, &q, &gravity);

    success = true;
  }

  return success;
}


void ZumiClass::delayForGyro(float time)
{
  unsigned long startTimeDrive = millis();
  while (millis() < startTimeDrive + (time * 1000))
  {
    while (!getGyro());
  }
}


void ZumiClass::moveForward(float time = 1, int speed = 60, float newAngle = 0)
{
  int dir = 0;
  if (newAngle < 0) dir = -1;
  else if (newAngle > 0) dir = 1;

  while (!getGyro());
  double desired_angle = eulerAngle(YAW) + newAngle;

  int max_speed = 127;
  double accuracy = 0.5;

  double k_p = 12;
  double k_i = 0.005;
  double k_d = 0.5;

  // Reset_PID
  PID_time_past = micros();
  error_sum = 0;
  error_past = 0;

  unsigned long start_time = micros();
  double speed_now = 0;
 // double accel_period = 0.7;

  while (((micros() - start_time) / 1000000) < abs(time))
  {
    MoveProcessForGyro(max_speed, abs(speed), desired_angle, k_p, k_d, k_i, accuracy, dir);
  }

  DCMove(stop, 0);
}

void ZumiClass::moveBackward(float time = 1, int speed = 60, float newAngle = 0)
{
  int dir = 0;
  if (newAngle < 0) dir = -1;
  else if (newAngle > 0) dir = 1;

  while (!getGyro());
  double desired_angle =  eulerAngle(YAW) + newAngle;

  int max_speed = 127;
  double accuracy = 0.8;

  double k_p = 12;
  double k_i = 0.005;
  double k_d = 0.5;

  // Reset_PID
  PID_time_past = micros();
  error_sum = 0;
  error_past = 0;

  unsigned long start_time = micros();
  double speed_now = 0;
//  double accel_period = 0.7;

  while (((micros() - start_time) / 1000000) < abs(time))
  {
    MoveProcessForGyro(max_speed, -1 * abs(speed), desired_angle, k_p, k_d, k_i, accuracy, dir);
  }

  DCMove(stop, 0);
}

//-----------------------------------------------------------------------------------------//

void ZumiClass::moveTurn(int direction, float newAngle, int speed = 60)
{
  int dir = 0;
  if (newAngle < 0) dir = -1;
  else if (newAngle > 0) dir = 1;

  while (!getGyro());

  if (direction == left) newAngle *= -1;
  double desired_angle = eulerAngle(YAW) + newAngle;

  double duration = 1.5;
  int max_speed = 25;
  double accuracy = 1;

  double k_p = 0.6;
  double k_i = 0.001;
  double k_d = 0.001;

  unsigned long start_time = micros();

  // Reset_PID
  PID_time_past = micros();
  error_sum = 0;
  error_past = 0;

  double speed_now = 0;
  double accel_period = 1.0;

  // ----------------------------------------

  if (duration >= accel_period)
  {
    while (((micros() - start_time) / 1000000) < accel_period)
    {
      if (speed_now < max_speed)
        speed_now = speed_now + 1;
      MoveProcessForGyro(abs(speed_now), 0, desired_angle, k_p, k_d, k_i, accuracy, dir);
    }
  }

  else if (duration < accel_period)
  {
    while (((micros() - start_time) / 1000000) < abs(duration * 0.6))
    {
      if (speed_now < max_speed)
        speed_now = speed_now + 1;
      MoveProcessForGyro(abs(speed_now), 0, desired_angle, k_p, k_d, k_i, accuracy, dir);
    }
  }

  // ------------------------------------------------------
  while (((micros() - start_time) / 1000000) < abs(duration))
  {
    MoveProcessForGyro(max_speed, 0, desired_angle, k_p, k_d, k_i, accuracy, dir);
  }

  DCMove(stop, 0);
}
//-----------------------------------------------------------------------------------------//

void ZumiClass::moveContinuousAngle(int speed = 60, float newAngle = 0)
{
  double k_p = 5;
  double k_i = 0.001;
  double k_d = 0.05;

  int dir = 0;

  MoveProcessForGyro(127, abs(speed), newAngle, k_p, k_d, k_i, 0.8, dir);
}


//-----------------------------------------------------------------------------------------//

void ZumiClass::MoveProcessForGyro(int max_speed, double base_speed, double desired_angle, double k_p, double k_d, double k_i, double min_error, int dir)
{
  while (!getGyro());
  double nowAngle = eulerAngle(YAW);
  double targetAngle = desired_angle;

  if (targetAngle > 180)
  {
    targetAngle = targetAngle - 180;
    targetAngle = fmodf(targetAngle, 360);
    targetAngle = targetAngle - 180;
  }

  if (targetAngle < -180)
  {
    targetAngle = targetAngle + 180;
    targetAngle = fmodf(targetAngle, 360);
    targetAngle = targetAngle + 180;
  }

  double error = 0;

  if (dir > 0)	error = targetAngle - nowAngle;
  else if (dir < 0)	 error = nowAngle - targetAngle;
  else	 error = targetAngle - nowAngle;

  if (abs(error) > 180)
  {
    error = 360 - abs(error);

    if (dir == 0)
    {
      if (nowAngle < 0)
    	error = error * -1;
    }

    if (dir > 0)
    {
      if (nowAngle < 0)
        error = error * -1;
    }
  }

  error_sum = error_sum + error;

  double error_change = error - error_past;
  error_past = error;

  // find change in time
  double dt = micros() - PID_time_past;
  dt = dt / 1000000;
  PID_time_past = micros();

  // PID components
  double e_p = (k_p * error);
  double e_d = (k_d * error_change / dt);
  double e_i = (k_i * error_sum * dt);
  int speed_offset = int(e_p + e_d + e_i);

  if (abs(error) < min_error)
    speed_offset = 0;

  base_speed = constrain(int(base_speed), -1 * MAX_USER_SPEED, MAX_USER_SPEED);

  int mRight = constrain(base_speed - speed_offset, -1 * max_speed, max_speed);
  int mLeft = constrain(base_speed + speed_offset, -1 * max_speed, max_speed);

  mLeft = constrain(mLeft, -126, 127);
  mRight = constrain(mRight, -126, 127);

  if (mLeft == 0)   mLeft = 0;
  else   mLeft += mLeft * 50 / abs(mLeft);

  if (mRight == 0)    mRight = 0;
  else  mRight += mRight * 50 / abs(mRight);

  int dirL = CCW;
  int dirR = CW;

  if (mLeft < 0)          dirL = CW;
  else if (mLeft > 0)     dirL = CCW;

  if (mRight > 0)         dirR = CW;
  else if (mRight < 0)    dirR = CCW;

  DCMotor(M1, dirL, abs(mLeft));
  DCMotor(M2, dirR, abs(mRight));
}


void ZumiClass::moveContinuousCircle(int direction, int speed, int step, float interval = 0.01)
{
  interval = interval * 1000;

  if (direction == left) step *= -1;

  double k_p = 2.9;
  double k_i = 0.01;
  double k_d = 0.05;

  int dir = 1;
  MoveProcessForGyro(127, abs(speed), currentAngle, k_p, k_d, k_i, 0.8, dir);

  unsigned long _currentTime = millis();
  if (_currentTime - prevTime > interval)
  {
    currentAngle += step;
    prevTime = _currentTime;
  }
}

void ZumiClass::moveCircle(int direction, int speed, int step, float interval = 0.01)
{
  interval = interval * 1000;

  int _currentAngle = 0;
  unsigned long _prevTime = 0;
  if (direction == left) step *= -1;

  while (!getGyro());
  float startAngle = eulerAngle(YAW);

  while (1)
  {
    double k_p = 2.9;
    double k_i = 0.01;
    double k_d = 0.05;

    int dir = 1;

    MoveProcessForGyro(127, abs(speed), startAngle + _currentAngle, k_p, k_d, k_i, 0.8, dir);

    unsigned long _currentTime = millis();
    if (_currentTime - _prevTime > interval)
    {
      _currentAngle += step;
      _prevTime = _currentTime;
    }

    if (abs(_currentAngle) > 361)  break;
  }

  DCMove(stop, 0);
}


void ZumiClass::moveAcrossBlocksForwardDetection(int threshold = 125, int forwardDetection = 0, float newAngle = 9999)
{
  boolean leftOnWhite = false;
  boolean rightOnWhite = false;
  int rightSwitch = 0;
  int leftSwitch = 0;

  int threshold_Blk = threshold + 30;
  byte decBL = 0, decBR = 0;

  while (!getGyro());

  float heading = eulerAngle(YAW);

  if(newAngle != 9999)
  {
    heading = newAngle;
  }

  while (1)
  {
    byte sensorBL = readIR(LEFT_BOTTOM_IR, true);
    byte sensorBR = readIR(RIGHT_BOTTOM_IR, true);

    byte sensorFR = readIR(RIGHT_FRONT_IR, true);
    byte sensorFL = readIR(LEFT_FRONT_IR, true);


    if (!decBL)
    {
     	if (sensorBL < threshold)	decBL = 1;
    }
    else
    {
	if (sensorBL > threshold_Blk)	decBL = 0;
    }

    if (!decBR)
    {
     	if (sensorBR < threshold)	decBR = 1;
    }
    else
    {
	if (sensorBR > threshold_Blk)	decBR = 0;
    }

    if ((sensorFL < forwardDetection) or (sensorFR < forwardDetection))
    {
    	break;
    //DCMove(stop, 0);
    }

    if (decBL)
    {
      if (!leftOnWhite)
      {
        leftSwitch += 1;
        leftOnWhite = true;
      }
    }
    else  leftOnWhite = false;

    if (decBR)
    {
      if (!rightOnWhite)
      {
        rightSwitch += 1;
        rightOnWhite = true;
      }
    }
    else  rightOnWhite = false;

    if ((rightOnWhite) and (!leftOnWhite)) heading += 0.1;
    if ((leftOnWhite) and (!rightOnWhite)) heading -= 0.1;

//    if ((rightSwitch == block) or (leftSwitch == block))  break;


  double k_p = 2.9;
  double k_i = 0.01;
  double k_d = 0.05;

/*
    double k_p = 4;
    double k_i = 0.001;
    double k_d = 0.05;
  */
    int dir = 0;

    MoveProcessForGyro(127, 10, heading, k_p, k_d, k_i, 0.5, dir);

  }
  DCMove(stop, 0);
}



void ZumiClass::moveAcrossBlocks(int block , int threshold = 125, float newAngle = 9999)
{
  boolean leftOnWhite = false;
  boolean rightOnWhite = false;
  int rightSwitch = 0;
  int leftSwitch = 0;

  int threshold_Blk = threshold + 30;
  byte decBL = 0, decBR = 0;

  while (!getGyro());

  float heading = eulerAngle(YAW);

  if(newAngle != 9999)
  {
    heading = newAngle;
  }

  while (1)
  {
    byte sensorBL = readIR(LEFT_BOTTOM_IR, true);
    byte sensorBR = readIR(RIGHT_BOTTOM_IR, true);

    byte sensorFR = readIR(RIGHT_FRONT_IR, true);
    byte sensorFL = readIR(LEFT_FRONT_IR, true);


    if (!decBL)
    {
     	if (sensorBL < threshold)	decBL = 1;
    }
    else
    {
	if (sensorBL > threshold_Blk)	decBL = 0;
    }

    if (!decBR)
    {
     	if (sensorBR < threshold)	decBR = 1;
    }
    else
    {
	if (sensorBR > threshold_Blk)	decBR = 0;
    }

    if (decBL)
    {
      if (!leftOnWhite)
      {
        leftSwitch += 1;
        leftOnWhite = true;
      }
    }
    else  leftOnWhite = false;

    if (decBR)
    {
      if (!rightOnWhite)
      {
        rightSwitch += 1;
        rightOnWhite = true;
      }
    }
    else  rightOnWhite = false;

    if ((rightOnWhite) and (!leftOnWhite)) heading += 0.1;
    if ((leftOnWhite) and (!rightOnWhite)) heading -= 0.1;

    if ((rightSwitch == block) or (leftSwitch == block))  break;


  double k_p = 2.9;
  double k_i = 0.01;
  double k_d = 0.05;

/*
    double k_p = 4;
    double k_i = 0.001;
    double k_d = 0.05;
  */
    int dir = 0;

    MoveProcessForGyro(127, 10, heading, k_p, k_d, k_i, 0.5, dir);

  }
  DCMove(stop, 0);
}



void ZumiClass::setIRChannel(int _ch)
{
  if (_ch == 1)
  {
    Button_up     = CH1_KEY_U;
    Button_down   = CH1_KEY_D;
    Button_left   = CH1_KEY_L;
    Button_right  = CH1_KEY_R;

    Button_center = CH1_KEY_C;

    Button_func1  = CH1_KEY_F1;
    Button_func2  = CH1_KEY_F2;
    Button_func3  = CH1_KEY_F3;
    Button_func4  = CH1_KEY_F4;

    Button_ch1    = CH1_KEY_CH1;
    Button_ch2    = CH1_KEY_CH2;
    Button_ch3    = CH1_KEY_CH3;
    Button_ch4    = CH1_KEY_CH4;
  }
  else if (_ch == 2)
  {
    Button_up     = CH2_KEY_U;
    Button_down   = CH2_KEY_D;
    Button_left   = CH2_KEY_L;
    Button_right  = CH2_KEY_R;

    Button_center = CH2_KEY_C;

    Button_func1  = CH2_KEY_F1;
    Button_func2  = CH2_KEY_F2;
    Button_func3  = CH2_KEY_F3;
    Button_func4  = CH2_KEY_F4;

    Button_ch1    = CH2_KEY_CH1;
    Button_ch2    = CH2_KEY_CH2;
    Button_ch3    = CH2_KEY_CH3;
    Button_ch4    = CH2_KEY_CH4;
  }
  else if (_ch == 3)
  {
    Button_up     = CH3_KEY_U;
    Button_down   = CH3_KEY_D;
    Button_left   = CH3_KEY_L;
    Button_right  = CH3_KEY_R;

    Button_center = CH3_KEY_C;

    Button_func1  = CH3_KEY_F1;
    Button_func2  = CH3_KEY_F2;
    Button_func3  = CH3_KEY_F3;
    Button_func4  = CH3_KEY_F4;

    Button_ch1    = CH3_KEY_CH1;
    Button_ch2    = CH3_KEY_CH2;
    Button_ch3    = CH3_KEY_CH3;
    Button_ch4    = CH3_KEY_CH4;
  }

  else if (_ch == 4)
  {
    Button_up     = CH4_KEY_U;
    Button_down   = CH4_KEY_D;
    Button_left   = CH4_KEY_L;
    Button_right  = CH4_KEY_R;

    Button_center = CH4_KEY_C;

    Button_func1  = CH4_KEY_F1;
    Button_func2  = CH4_KEY_F2;
    Button_func3  = CH4_KEY_F3;
    Button_func4  = CH4_KEY_F4;

    Button_ch1    = CH4_KEY_CH1;
    Button_ch2    = CH4_KEY_CH2;
    Button_ch3    = CH4_KEY_CH3;
    Button_ch4    = CH4_KEY_CH4;
  }
}


int ZumiClass::readIRreceiver()
{
  unsigned long IRresult = 0;

#if  defined(IRREMOTE_USE)

  if (irrecv.decode(&results))
  {
    IRresult = results.value;
    irrecv.resume(); // Receive the next value
  }
  IRresult = (IRresult >> 8) & 0xff;

#endif

  return IRresult;
}

void ZumiClass::startIRreceiver()
{
#if  defined(IRREMOTE_USE)
  irrecv.enableIRIn();
#endif
}

void ZumiClass::MotorInit()
{
  // Set Motor Pin
  pinMode(MOTOR_LEFT_A, OUTPUT);
  pinMode(MOTOR_LEFT_B, OUTPUT);
  pinMode(MOTOR_RIGHT_A, OUTPUT);
  pinMode(MOTOR_RIGHT_B, OUTPUT);

  // Stop motors
  digitalWrite(MOTOR_LEFT_A, LOW);
  digitalWrite(MOTOR_LEFT_B, LOW);
  digitalWrite(MOTOR_RIGHT_A, LOW);
  digitalWrite(MOTOR_RIGHT_B, LOW);
}

void ZumiClass::DCMove(byte direction, byte speed)
{
  if (direction == forward)
  {
    DCMotor(M1, CCW, speed);
    DCMotor(M2, CW, speed);
  }
  else if (direction == backward)
  {
    DCMotor(M1, CW, speed);
    DCMotor(M2, CCW, speed);
  }
  else if (direction == left)
  {
    DCMotor(M1, CW, speed);
    DCMotor(M2, CW, speed);
  }
  else if (direction == right)
  {
    DCMotor(M1, CCW, speed);
    DCMotor(M2, CCW, speed);
  }
  else if (direction == stop)
  {
    DCMotor(M1, STOP, 0);
    DCMotor(M2, STOP, 0);
  }
  else if (direction == loose)
  {
    DCMotor(M1, LOOSE, 0);
    DCMotor(M2, LOOSE, 0);
  }
}

void ZumiClass::DCMotor(char SelectMotor, char direction, char speed)
{
  if (SelectMotor == M1)
  {
    if (direction == CW)
    {
      analogWrite(MOTOR_LEFT_A, 0);
      analogWrite(MOTOR_LEFT_B, speed);
    }
    else if (direction == CCW)
    {
      analogWrite(MOTOR_LEFT_A, speed);
      analogWrite(MOTOR_LEFT_B, 0);
    }
    else
    {
      analogWrite(MOTOR_LEFT_A, 0);
      analogWrite(MOTOR_LEFT_B, 0);
    }
  }

  else if (SelectMotor == M2)
  {
    if (direction == CW)
    {
      analogWrite(MOTOR_RIGHT_A, speed);
      analogWrite(MOTOR_RIGHT_B, 0);
    }
    else if (direction == CCW)
    {
      analogWrite(MOTOR_RIGHT_A, 0);
      analogWrite(MOTOR_RIGHT_B, speed);
    }
    //  else if ((direction == STOP) or (direction == LOOSE))
    else
    {
      analogWrite(MOTOR_RIGHT_A, 0);
      analogWrite(MOTOR_RIGHT_B, 0);
    }
  }
}

void ZumiClass::OLED_Clear() {
  #if  defined(OLED_USE)

  u8g.firstPage();
  do {
  } while ( u8g.nextPage() );

#endif
}

void ZumiClass::OLED_ChargingAnimation()
{
#if  defined(OLED_USE)

  // emptyBattery
  u8g.firstPage();
  do {
   u8g.drawBitmapP(0, 0, 16, 64, zumi_charging_fullsize);
  } while ( u8g.nextPage() );

#endif
}

void ZumiClass::OLED_EyeAnimation()
{
#if  defined(OLED_USE)

  u8g.firstPage();
  do {
    u8g.drawBitmapP( 0, 0, 16, 64, opened_eyes);
  } while ( u8g.nextPage() );

#endif
}

void ZumiClass::OLED_ZumiLOGO()
{
  #if  defined(OLED_USE)

    u8g.firstPage();
    do {
      u8g.drawBitmapP( 0, 0, 16, 64, zumi_logo_fullsize);
    } while ( u8g.nextPage() );

  #endif
}

void ZumiClass::OLEDAnimation(int dp)
{
  #if  defined(OLED_USE)

    if(dp == ZUMI_LOGO) OLED_ZumiLOGO();
    else if(dp == OPEN_EYES) OLED_EyeAnimation();
    else if(dp == CHARGING) OLED_ChargingAnimation();

  #endif
}

void ZumiClass::LEDOnOff(int led, boolean onOff)
{
  if(led == FRONT_LEFT) {
    if(onOff == ON) digitalWrite(FRONT_LEFT_LED, HIGH);
    else if(onOff == OFF) digitalWrite(FRONT_LEFT_LED, LOW);
  }
  else if(led == FRONT_RIGHT) {
    if(onOff == ON) digitalWrite(FRONT_RIGHT_LED, HIGH);
    else if(onOff == OFF) digitalWrite(FRONT_RIGHT_LED, LOW);
  }
  else if(led == BACK_LEFT) {
    if(onOff == ON) digitalWrite(BACK_LEFT_LED, HIGH);
    else if(onOff == OFF) digitalWrite(BACK_LEFT_LED, LOW);
  }
  else if(led == BACK_RIGHT) {
    if(onOff == ON) digitalWrite(BACK_RIGHT_LED, HIGH);
    else if(onOff == OFF) digitalWrite(BACK_RIGHT_LED, LOW);
  }

}

void ZumiClass::OLEDBattery()
{
  #if  defined(OLED_USE)

    float bat = checkBattery();
    bat = movAvgFilter(bat);
    if(bat <= MINVOLT) boxWidth = 0;
    else boxWidth = map(bat, MINVOLT, MAXVOLT, 0, 38);

    u8g.setFont(u8g_font_unifont);
    u8g.firstPage();
    do {
      u8g.drawBitmapP(0, 0, 16, 64, zumi_charging_fullsize);
      u8g.drawBox(43,15,boxWidth,15);
      u8g.setPrintPos(45, 50);
      u8g.print(bat);
      u8g.setPrintPos(75, 50);
      u8g.print("V");
      } while( u8g.nextPage() );

  #endif
}

void ZumiClass::OLEDIRSensor()
{
  #if  defined(OLED_USE)

    String posName[] = {"FR:", "BR:", "RR:", "BL:", "RL:", "FL:" };
    int xPos[] =  {0, 0, 0, 75, 75, 75};
    int yPos[] =  {20, 60, 40, 60, 40, 20};

    u8g.setFont(u8g_font_unifont);
    u8g.firstPage();
    do {
         for (int j = 0; j < 6; j++)
         {
            byte ir = readIR((j + 1), 1);
            u8g.setFont(u8g_font_unifont);
            u8g.setPrintPos(xPos[j], yPos[j]);
            u8g.print(posName[j]);
            u8g.setPrintPos((xPos[j] + 25), yPos[j]);
            u8g.print(ir);
         }
    } while( u8g.nextPage() );

  #endif
}

void ZumiClass::OLEDYPROutput()
{
  #if  defined(OLED_USE)

    const int xPos = 20;
    const int yPos = 20;

    float yaw = eulerAngle(YAW);
    float pitch = eulerAngle(PITCH);
    float roll = eulerAngle(ROLL);

    u8g.setFont(u8g_font_unifont);
    u8g.firstPage();
    do {
      u8g.setFont(u8g_font_unifont);
      u8g.setPrintPos(xPos, yPos);
      u8g.print("YAW:");
      u8g.setPrintPos(xPos + 30, yPos);
      u8g.print(yaw);
      u8g.setPrintPos(xPos, yPos + 20);
      u8g.print("PITCH:");
      u8g.setPrintPos(xPos + 50, yPos + 20);
      u8g.print(pitch);
      u8g.setPrintPos(xPos, yPos + 40);
      u8g.print("ROLL:");
      u8g.setPrintPos(xPos + 40, yPos + 40);
      u8g.print(roll);
    } while( u8g.nextPage() );

  #endif
}

void ZumiClass::OLEDIRRemocon()
{
  #if  defined(OLED_USE)

    const int xPos = 35;
    const int yPos = 25;
    uint8_t recv = readIRreceiver();

    u8g.setFont(u8g_font_unifont);
    u8g.firstPage();
    do {
      u8g.setFont(u8g_font_unifont);
      u8g.setPrintPos(xPos, yPos);
      u8g.print("IR:");
      u8g.setPrintPos(xPos + 30, yPos);
      u8g.print(recv);
    } while( u8g.nextPage() );

  #endif
}

void ZumiClass::OLEDOutput(int sel)
{
  #if  defined(OLED_USE)

    if(sel == BATTERY) OLEDBattery();
    else if(sel == IR_SENSOR) OLEDIRSensor();
    else if(sel == EULER_ANGLE) OLEDYPROutput();
    else if(sel == IR_REMOCON) OLEDIRRemocon();

  #endif
}

float ZumiClass::map(float x, float in_min, float in_max, float out_min, float out_max) {
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

float ZumiClass::movAvgFilter(float x)
{
  float avg = 0, sum = 0;

  if(firstRun == true)
  {
    n = 10;
    for(int i=0; i < n; i++) xbuf[i] = x;    //Initializing by first input value
    firstRun = false;
  }

  for (int i = 0; i < n-1; i++) xbuf[i] = xbuf[i+1];  // pushing the data to lower memory
  xbuf[n-1] = x;

  for (int i = 0; i <n; i++)
  {
    sum = sum + xbuf[i];
  }
  avg = sum / n;

  return avg;
}

extern ZumiClass Zumi = ZumiClass();
