
this.rokit = {
  usedPorts : new Array(),
  portList : new Array(),
  streamMsg : String,
  hardware : int = -1,
  streamingStatus : int = 0,
  progressValue : float = 0,
  progressCount : int = 0,
  delayCnt : int = 0,
  errCode : int = 0,
  buildErrCode : int = 0,
};

this.streamingStatus = {
  wait : int = 0,
  onStreaming : int = 1,
  progStart : int = 2,
  progFinish : int = 3,
};

this.uploadStatus = {
  compileFinish : false,
  compileResult : int = 0,
  uploadFinish : false,
  uploadResult : int = 0,
};

function fadeOut() {
  $('#back').css("background-color", "black");
  //$('#back').animate({opacity:"0.3"}, 1);
  $('#title').animate({opacity:"0.3"}, 1);
  $('#selbox2').animate({opacity:"0.3"}, 1);
  $('#portButton').animate({opacity:"0.3"}, 1);
  $('#textBox').animate({opacity:"0.3"}, 1);
  $('#uploadBtn').animate({opacity:"0.3"}, 1);
  $('#myProgress').css("display","block");
  $('#myBar').css("display","block");
  $('#label').css("display","block");
  $('#message').css("display","block");
}

function fadeIn() {
  $('#myProgress').css("display","none");
  $('#myBar').css("display","none");
  $('#label').css("display","none");
  $('#message').css("display","none");

  $('#uploadBtn').animate({opacity:"1.0"}, 1);
  $('#textBox').animate({opacity:"1.0"}, 1);
  $('#portButton').animate({opacity:"1.0"}, 1);
  $('#selbox2').animate({opacity:"1.0"}, 1);
  $('#title').animate({opacity:"1.0"}, 1);
  $('#back').css("background-color", "white");
}

var Serialport = require('browser-serialport');
var fs = require('fs');
var userHome = require('user-home');
var async = require('async');

var workDir;
var buildDir;
var cacheDir;
var codePath;
var OLEDCompileMsg;
var functionCallErrMsg;

var language = this.getSetting('language');
console.log("language: " + language);

localStorage.setItem('upload', 'OFF');
localStorage.setItem('usedPort', ' ');

setTimeout(function(){
  var err = makeDir();
}, 500);

setTimeout(function(){ addPorts(); readCode();}, 1000);
setInterval(function(){ readCode(); }, 2000);

//search user-home
userHome = userHome.replace(/\\/gi, "/");
console.log(userHome);

require('nw.gui').Window.get().on('close', function () {
    var myself = this;
    if(localStorage.getItem('upload') == 'ON')
    {
      if (confirm('Uploading is not finished. Are you sure want to exit? ')) {
            console.log("window close!!");
            this.close(true);
      }
    }
    else this.close(true);
});

function getSetting(key) {
  if (localStorage) {
      return localStorage['-snap-setting-' + key];
  }
  return null;
};

function lockPort(port) {
  var usedPort = localStorage.getItem('usedPort');
  if(usedPort.indexOf(port) == -1)  {
   usedPort = usedPort + port;
   localStorage.setItem('usedPort', usedPort);
  }
}

function unlockPort(port) {
  var usedPort = localStorage.getItem('usedPort');
  if (usedPort.indexOf(port) > -1) {
    usedPort = usedPort.replace(port, "");
    localStorage.setItem('usedPort', usedPort);
  }
}

function isPortLocked(port) {
  var usedPort = localStorage.getItem('usedPort');
  console.log(usedPort);
  return (usedPort.indexOf(port) > -1);
}


var getSerialports = function(callback) {
  var myself = this.rokit;
  var portList = [];

  Serialport.list(function (err, ports) {
    if(ports) {
        ports.forEach(function(each) {
          console.log(each.comName); console.log(each.pnpId); console.log(each.manufacturer);
          //console.log(isPortLocked(each.comName));
          if(isPortLocked(each.comName) == false) portList[each.comName] = each.comName;   //dictionary
        });
        portList = (Object.keys(portList));
        myself.portList = portList;
        callback(portList);
    }
  });
}

function addPorts(){
  var frm = document.form2;
  getSerialports(function(ports) {
    console.log(ports+ " " + frm.ports.length);
    var idx = frm.ports.length;
    while(idx > 1) {
      frm.ports.options.remove(idx - 1);
      idx--;
    }
    for (var k = 0; k < ports.length; k++) {
      var op = new Option();
      op.value = frm.ports.length;
      op.text = ports[k];
      op.selected = false;
      frm.ports.options.add(op);
      console.log(op);
    }
  });
}

function readCode() {
  var myself = this;
  var path = codePath;
  var readFile = '/genCode.ino';
  var OLEDText =" ";
  var results;
  var call = new Array();
  var cnt = 0;


  fs.readFile(path + readFile , function(err, data) {
    if(err) {throw err; return -1;}
    else {
      //console.log("print!!");
      $('#mytext').val(data);
      var codes = data.toString();
      // find the OLEDBLOCK in codes
      if(codes.indexOf('OLED_USE') != -1) {
        OLEDCompileMsg = "It may be slows down when using OLED Blocks";
      }
      else OLEDCompileMsg ="";
      // find the forverblock if using at ance
      //myself.buildErrCode = 0;
      results = codes.match(/loop()/g);
      if(results != null) {
        if(results.length > 1) myself.rokit.buildErrCode = 1;
        else myself.rokit.buildErrCode = 0;
        //console.log("BUILD ERROR CODE: " + myself.rokit.buildErrCode);
      }
     // find the invalid call
     results = codes.match(/(.*)[()]/g);
     if(results != null) {
        cnt = 0;
        textTemp = "void ";
        functionCallErrMsg = " ";

        for(var j = 0; j < results.length; j++)
        {
          if((results[j].indexOf('WR_') == -1)&&(results[j].indexOf('Zumi') == -1)&&(results[j].indexOf('=') == -1)&&(results[j].indexOf('void') == -1)&&(results[j].indexOf('if') == -1)&&(results[j].indexOf('for') == -1)&&(results[j].indexOf('while') == -1)&&(results[j].indexOf('millis') == -1)) {
            call[cnt] = textTemp.concat(results[j].replace(/ /gi, "")); //들여쓰기시 함수이름 앞에 생기는 공백을 지운다 
            cnt++;
          }
        }
       for(var k = 0; k < call.length; k++)
       {
         if(codes.indexOf(call[k]) == -1) {
           console.log("err_no_function :" + call[k]);

           if(myself.rokit.buildErrCode == 0) {myself.rokit.buildErrCode = 2; functionCallErrMsg = call[k]; } // formal error reserved..
           console.log("BUILD ERROR CODE: " + myself.rokit.buildErrCode);
         }
         else myself.rokit.buildErrCode = 0;
       }

      //$('#textBox').text(data);
      //var array = data.toString().split("\n");
      //for (i in array) {
      //  myText = myText + array[i];
      //  console.log(myText + "\n");
      //document.getElementById('mytext').innerHTML = myText; // 이건 갱신이 안됨
     }
    }
  });
}

var progressBarHandler = function(stat) {
  var myself = this;
  var bar = document.getElementById("myBar");
  var msg = document.getElementById("label");
    if(stat == true)  myself.progressBar = setInterval(function() {
      bar.style.width = "" + (myself.rokit.progressValue * 0.582) + "%";  //1.8.9 builder counting until 170%
      msg.innerHTML = "" + parseInt(myself.rokit.progressValue * 0.582) + "%";
    }, 10);
    else clearInterval(myself.progressBar);
}

function makeDir() {
  var mkdirp = require('mkdirp');
  var error = false;
  workDir = userHome + "/arduino121";
  mkdirp(workDir, function (err) {
    if (err) { console.error(err); error = true; }
    else {
      buildDir = workDir + "/arduino_build";
      cacheDir = workDir + "/arduino_cache";
      var codefolderPath = workDir + "/code";
      codePath = codefolderPath + "/genCode";
      //console.log(buildDir);
      mkdirp(buildDir, function (err) {
        if (err) { console.error(err); error = true; }
        else {
          console.log("make build path!!");
        }
      });
      mkdirp(cacheDir, function (err) {
        if (err) { console.error(err); error = true; }
        else {
          console.log("make cache path!!");
        }
      });
      mkdirp(codefolderPath, function (err) {
        if (err) { console.error(err); error = true; }
        else {
          console.log("make code folder path!!");
        }
      });
      mkdirp(codePath, function (err) {
        if (err) { console.error(err); error = true; }
        else {
          console.log("make code path!!");
        }
      });
    }
  });
  return error;
}

function compileLinky() {
  var myself = this;
  var port;
  var msg;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn3 = document.getElementById('btn3');

//  if(idx <= 0) {
//    fadeIn();
//    if(alert('먼저 업로드할 포트를 선택하세요!')) {
//      return;
//    }
//  }
//  else {
    btn1.disabled = true;
    btn3.disabled = true;
    var selectedPort = frm.ports.options[idx].text;
    console.log(selectedPort + " " + idx);
    if(language == "ko") msg = "컴파일을 시작합니다...";
    else msg = "Start the compilation..."
    document.getElementById("message").innerHTML = msg;
    codeCompile();
//  }
}

function codeCompile() {
  var myself = this;
  var msg = ""; 
  var btn1 = document.getElementById('btn1');
  var btn3 = document.getElementById('btn3');
  //console.log("build path : " + buildDir);
  //console.log("cache path : " + cacheDir);
  var spawn = require('child_process').spawn;
  var hardwarePath = 'hardware';
  var rokitHardwarePath = 'rokitHardware';
  var toolsPath_1 = 'tools-builder';
  var toolsPath_2 = 'hardware/tools/avr';
  var builtInLibrariesPath = 'libraries';
  var librariesPath = 'RokitLibraries';
  var buildPath = buildDir;
  var buildCachePath = cacheDir;
  var avrdudePath = '/';
  var avrgccPath = 'hardware/tools/avr';
  var OTAPath = 'hardware/tools/avr';
  //var codePath = 'code/autoConnect/autoConnect.ino';
  var codePos = codePath + "/genCode.ino";
  var streamMsg;

  var arduinoBuilderPref = spawn('arduino-builder', [ '-compile', '-logger=machine', '-hardware', hardwarePath, '-hardware', rokitHardwarePath, '-tools', toolsPath_1, '-tools', toolsPath_2, '-fqbn=arduino:avr:pro:cpu=16MHzatmega328', '-ide-version=10803', '-built-in-libraries', builtInLibrariesPath, '-libraries', librariesPath, '-build-path', buildPath, '-warnings=none', '-build-cache', buildCachePath,  '-prefs=build.warn_data_percentage=75',  '-prefs=runtime.tools.avrdude.path=' + avrdudePath, '-prefs=runtime.tools.avr-gcc.path=' + avrgccPath, '-prefs=runtime.tools.arduinoOTA.path=' + OTAPath, '-verbose', codePos ], {cwd:'arduino'});


  arduinoBuilderPref.stdout.on('data', (data) => {
      console.log(`stdout: ${data}`);
      streamMsg = "" + data;
      if(this.rokit.streamingStatus == myself.streamingStatus.onStreaming) {
        localStorage.setItem('upload', 'ON');
        myself.rokit.streamingStatus = myself.streamingStatus.progStart;
        if(language == "ko") msg = "컴파일 중...";
        else msg = "Compiling..."
        document.getElementById("message").innerHTML = msg + OLEDCompileMsg ;
      }
      else if(myself.rokit.streamingStatus == myself.streamingStatus.progStart) {
        //var count = (streamMsg.match(/|/g) || []).length;
        //console.log(count);
        var array = streamMsg.toString().split("info");
        for (i in array) {
          var start = array[i].indexOf("[");
          var end = array[i].indexOf("]", start + 1);
          var progValue = (Number(array[i].substring(start+1, end)));
          if  ((!isNaN(progValue))&&(progValue != 0)) {
          //  console.log("###" + progValue + "###");
            myself.rokit.progressValue = progValue;
          }
          //else {console.log("---" + progValue + "---");}
        }
        if(myself.rokit.progressValue >= 170) myself.rokit.streamingStatus = myself.streamingStatus.progFinish;
      }
      else if(myself.rokit.streamingStatus == myself.streamingStatus.progFinish) {
        if(language == "ko") msg = "컴파일이 완료되었습니다.";
        else msg = "Compilation completed.";
        document.getElementById("message").innerHTML = msg;
      }
  });

  arduinoBuilderPref.stderr.on('data', (data) => {
    console.log(`stderr: ${data}`);
  });

  arduinoBuilderPref.on('close', (code) => {
    console.log(`child process exited with code ${code}`);
    if(Number(code) == 0) {
      myself.uploadStatus.compileFinish = true;
      myself.uploadStatus.compileResult = 0;
      myself.rokit.streamingStatus = myself.streamingStatus.wait;
      console.log("no error!");
    }
    else {
      myself.uploadStatus.compileFinish = true;
      myself.uploadStatus.compileResult = 1;
      myself.rokit.streamingStatus = myself.streamingStatus.wait;
      if(language == "ko") msg ="컴파일중 에러 발생... 종료합니다";
      else msg = "Error occured during compiling... exit";
      document.getElementById("message").innerHTML = msg;
      console.log("error!");
      btn1.disabled = false;
      btn3.disabled = false;
    }
  });
}

function uploadLinky() {
  var myself = this;
  var port;
  var msg;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn3 = document.getElementById('btn3');

  if(idx <= 0) {
    if(alert('Please select the port you want to upload first!')) return;
  }
  else {
    btn1.disabled = true;
    btn3.disabled = true;
    var selectedPort = frm.ports.options[idx].text;
    console.log(selectedPort + " " + idx);
    if(language == "ko") msg ="업로드를 시작합니다...";
    else msg = "Start uploading...";
    document.getElementById("message").innerHTML = msg;
    uploading(selectedPort);
  }
}

function uploading(port) {
  var myself = this;
  var msg = "";
  var avrdude;
  var streamMsg;
  var comPort = '-P'+ port;
  var flashfile = '-Uflash:w:' + buildDir + '/genCode.ino.hex:i';
  var uploadBtn1 = document.getElementById('uploadBtn');
  //console.log("comPort: " + comPort);
  var spawn = require('child_process').spawn;

  avrdude = spawn('avrdude',['-C', 'avrdude.conf', '-v', '-patmega328p', '-carduino', comPort, '-b115200', '-D', flashfile],  {cwd:'arduino'});

  avrdude.stdout.on('data', (data) => {
    console.log(`stdout: ${data}`);
  });

  avrdude.stderr.on('data', (data) => {
    //console.log(`stderr: ${data}`);
    streamMsg = "" + data;
    if(myself.rokit.streamingStatus == myself.streamingStatus.onStreaming) {
        localStorage.setItem('upload', 'ON');
        if(streamMsg.indexOf('Writing') != -1 ) {
          myself.rokit.streamingStatus = myself.streamingStatus.progStart;
          if(language == "ko") msg ="업로드 중...";
          else msg = "Uploading...";
          document.getElementById("message").innerHTML = msg;
        }
        if(streamMsg.indexOf('not in sync')!= -1)  {
          myself.rokit.delayCnt++;
          if(language == "ko") msg ="전송이 지연되고 있습니다... 재시도 중(" + myself.rokit.delayCnt +"/10)";
          else msg = "The transmission is being delayed... Retrying(" + myself.rokit.delayCnt +"/10)";
          document.getElementById("message").innerHTML = msg;
        }
    }
    else if(myself.rokit.streamingStatus == myself.streamingStatus.progStart) {
      var count = (streamMsg.match(/#/g) || []).length;
      myself.rokit.progressCount = myself.rokit.progressCount + count;
      myself.rokit.progressValue =   (myself.rokit.progressCount * 1.72); //for compiling graph = uploading graph
      if(myself.rokit.progressCount >= 100) myself.rokit.streamingStatus = myself.streamingStatus.progFinish;
    }
    else if(myself.rokit.streamingStatus == myself.streamingStatus.progFinish) {
      if(language == "ko") msg ="업로드가 끝났습니다";
      else msg = "Uploading completed.";
      document.getElementById("message").innerHTML = msg;
    }
    //console.log("PROGRESS:" + myself.rokit.progressCount + " " + myself.rokit.streamingStatus);
    console.log(streamMsg);
  });

  avrdude.on('close', (code) => {
    var myself = this;
    var msg = "";
    myself.rokit.errCode = code;
    setTimeout( function() {
      fadeIn();
      progressBarHandler(false);
      var btn1 = document.getElementById('btn1');
      var btn3 = document.getElementById('btn3');
      localStorage.setItem('upload','OFF');
      btn1.disabled = false;
      btn3.disabled = false;
      myself.rokit.progressCount = 0;
      myself.rokit.delayCnt = 0;
      myself.rokit.streamingStatus = myself.streamingStatus.wait;
      myself.rokit.progressValue = 0;
      
      if(language == 'ko') msg = "업로드를 시작합니다..."
      else msg = "Start uploading..."
      document.getElementById("message").innerHTML = msg;

      if(myself.rokit.errCode > 0) {
        if(language == 'ko') msg = "포트와 연결할 수 없습니다.\n액션플레이와 포트가 이미 연결되어 있다면 해제해 주세요!"
        else msg = "Unable to connect port.\nIf the port is already connected to ActionPlay, please disconnect!"
        alert(msg);
        //alert('Failed to upload. Please check the compilation.');
      }
    }, 2000);
    console.log(`child process exited with code ${code}`);
  });
}

function upload() {
  var myself = this;
  var err;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var msg = ""

  if((idx <= 0)||(myself.rokit.buildErrCode > 0 )) {
    fadeIn();
    if(idx <= 0) {
      if(language == 'ko')  msg = "먼저 연결할 포트를 선택하세요!";
      else msg = "Please select the port you want to upload first!" ;

      if(alert(msg)) return;
    }
    else if(myself.rokit.buildErrCode > 0) {
      if(myself.rokit.buildErrCode  == 1) {
        if(alert('ERROR: "forever" block should only be used one!')) return;
      }
      else if(myself.rokit.buildErrCode == 2) {
        if(alert('ERROR: The follow function to be called does not exist! :\n' + functionCallErrMsg +'\n' + 'Use the "When I receive" block!')) return;
      }
    }
  }
  else {
    async.waterfall([
        function (callback) {
          if(err) { callback(err); }
          console.log("flow0!");
          progressBarHandler(true);
          myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
          fadeOut();
          callback(null);
        },
        function (callback) {
          if(err) { callback(err); }
          console.log("flow1!");
          //error = makeDir();
          callback(null, 'success');
        },
        function (arg, callback) {
          if(err) { console.log("error!"); callback(err); }
          console.log("flow2! " + arg);

          setTimeout(function() {
            compileLinky();
          }, 500);

          var repeat =  setInterval(function() {
              //console.log("COMPILEFINISH: " + myself.uploadStatus.compileFinish);
              if(myself.uploadStatus.compileFinish == true) {
                clearInterval(repeat);
                if(myself.uploadStatus.compileResult == 0) {
                  setTimeout(function() {
                    myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
                    uploadLinky();
                    myself.uploadStatus.compileFinish = false;
                    myself.rokit.progressValue = 0;
                    //progressBarHandler(false);
                    //fadeIn();
                  }, 500);
                }
                else {  // 컴파일시 문제 생겼을 때 처리 부분
                  myself.rokit.streamingStatus = myself.streamingStatus.wait;
                  myself.rokit.progressValue = 0;
                  myself.uploadStatus.compileFinish = false;
                  myself.rokit.progressValue = 0;
                  progressBarHandler(false);
                  setTimeout(function() { fadeIn(); }, 2000);
                }
              }
            }, 500);
        //setTimeout(function(){ if(err == false) codeCompile(); }, 500);
          callback(null, 'success3');
        },
        function (arg, callback) {
          console.log("flow3! " + arg);
          callback(null);
        }],
        function (err, result) {
          if(err) { console.log(err); }

          console.log("finish!!");
        });
      }
  }
