/*
    Changes to WorldMorph for managing Snap4Arduino functions
*/

/**
 * Global object (world.Arduino) used for s4a/arduino properties
 */
WorldMorph.prototype.Arduino = {
  //  firmata : require('firmata'),
    serialport : require('browser-serialport'),
    fs : require('fs'),
    portList : [],
    usedPorts : [],
    myVersion : 1.26,
    isChildOpen : false
};

WorldMorph.prototype.Arduino.importVersion = function(ver, exVer) {
 var myself = this;
 myself.fs.readFile('arduino/firmware/versionInfo.txt', function(err, data) {
     if(err) {throw err; return -1;}
     var array = data.toString().split("\n");
     for (i in array) {
       //console.log(array[i]);
     }
     if(array[0].indexOf("robolink") != -1) {                              //�ٸ� ������ �ε� �Ǿ��ִ� ���� �Ǵ�
       exVer = array[4].replace("#app_rokitbrick:", "");
       console.log(exVer);
    }
    else {
      console.log("error!");
      exVer = myself.myVersion;
      console.log(exVer);
    }
 myself.versionInfoDownloadCompare(ver, exVer);
 });
}

WorldMorph.prototype.Arduino.versionInfoDownloadCompare = function(ver, exVer) {
  var myself = this;
  var download1 = require('download-file');
  var url = "http://robolink.ipdisk.co.kr:80/publist/HDD2/HDD2/firmware/versionInfo.txt";
  var options = {
      directory: "arduino/firmware",
      filename: "versionInfo.txt"
  }
  download1(url, options, function(err){
    if (err) throw err;

    myself.fs.readFile('arduino/firmware/versionInfo.txt', function(err, data) {
        if(err) {throw err; return -1; console.log(err);}
        var array = data.toString().split("\n");
        for (i in array) {
          //console.log(array[i]);
        }
        if(array[0].indexOf("robolink") != -1) {
          ver = array[4].replace("#app_rokitbrick:", "");
          console.log(ver);
        }
        else {
          ver = myself.myVersion;
        }
        exVer = parseFloat(exVer);
        ver = parseFloat(ver);
        //console.log(ver.inventor + " " + ver.linky + " " + ver.helperapp);
        if(ver > myself.myVersion) {
          setTimeout(function() {
            alert(localize('A newer version of Rokitbrick was found.\r\nDownload from www.robolinksw.com!'));
          }, 3000);
        }
    });
  });
}

/*
WorldMorph.prototype.Arduino.titleInfoImport = function() {
  var myself = this;
  var download1 = require('download-file');
  var url = "http://robolink.ipdisk.co.kr:80/publist/HDD2/HDD2/firmware/RBCodroneTitleInfo.html";
  var options = {
      directory: "info",
      filename: "RBCodroneTitleInfo.html"
  }
  download1(url, options, function(err){
    if (err) throw err;
  });
  console.log("info loaded!!");
}
*/

var appVersion = 0, exAppVersion = 0;
//WorldMorph.prototype.Arduino.titleInfoImport();
WorldMorph.prototype.Arduino.importVersion(appVersion, exAppVersion);



WorldMorph.prototype.Arduino.sleep = function(milliseconds) {
  var start = new Date().getTime();
  for (var i = 0; i < 1e7; i++) {
    if ((new Date().getTime() - start) > milliseconds){
        break;
      }
    }
}
/**
 * Locks the given port to prevent its use in other connection (until it is unlocked)
 */
WorldMorph.prototype.Arduino.lockPort = function (port) {
    var usedPorts = this.usedPorts;

    if (usedPorts.indexOf(port) === -1) {
        usedPorts.push(port);
    }
}

/**
 * Unlocks a previously Locked port to permit its use in new connections
 * Should be called when closing connections
 */
WorldMorph.prototype.Arduino.unlockPort = function (port) {
    var usedPorts = this.usedPorts;
    console.log("taken port: " + port);
    if (usedPorts.indexOf(port) > -1) {
        console.log("port index: " + usedPorts.indexOf(port));
        usedPorts.splice(usedPorts.indexOf(port), 1);
    }
}

/**
 * Informs whether the port is locked or unlocked
 */
WorldMorph.prototype.Arduino.isPortLocked = function (port) {
    return (this.usedPorts.indexOf(port) > -1)
}


/**
 * Gets a list of available serial ports (paths) and return it through callback function
 */
WorldMorph.prototype.Arduino.getSerialPorts = function (callback) {
    var myself = this;

    var portList = [];
    var portcheck = /usb|DevB|rfcomm|acm|^com/i; // Not sure about rfcomm! We must dig further how bluetooth works in Gnu/Linux

    myself.serialport.list(function (err, ports) {
        if (ports) {
            ports.forEach(function(each) {
                if(!myself.isPortLocked(each.comName) && portcheck.test(each.comName)) {
                    portList[each.comName] = each.comName;
                }
            });
        }
        callback(portList);
    });

};


WorldMorph.prototype.Arduino.transpile = function (body, hatBlocks) {
  var header = '',
      setupHeader = '',
      broadcasts = '',
      assignments = '';

      // First of all, let's deal with possible broadcasts
  if (body.indexOf('!call!') > 0) {
      // Message names are now function names, not strings
      body = body.replace(/!call!"(.*)"/g, '$1');
      broadcasts = this.processBroadcasts(hatBlocks, body);
  }

  header +=
  '#include <Zumi.h">\n'
  + '#include <Servo.h>\n'
  + 'Servo servos[MAX_SERVOS];\n'
  + 'byte servoPinMap[TOTAL_PINS];\n'
  + 'byte detachedServos[MAX_SERVOS];\n'
  + 'byte detachedServoCount = 0;\n'
  + 'byte servoCount = 0;\n\n';

  varLines = body.match(/int .* = 0;/g) || [];
  body = body.replace(/int .* = 0;\n/g, '');
  varLines.forEach(function (each) {
      assignments += each + '\n';
  });

  body = assignments + '\n' + body;
  setupHeader += '\n  for (byte i = 0; i < TOTAL_PINS; i++) { servoPinMap[i] = 255; } // Auto-generated by Snap4Arduino. Do not remove.\n';
  body = body.replace('void setup() {', '$&' + setupHeader);
  body = body.replace(/, clockwise\)/g, ', 1200)');
  body = body.replace(/, stopped\)/g, ', 1500)');
  body = body.replace(/, counter-clockwise\)/g, ', 1800)');
  body = body.replace(/, disconnected\)/g, ', -1)');

    // If there's no loop function, we need to add an empty one
  if (body.indexOf('void loop()') < 0) {
      body += '\n}\n\nvoid loop() {}\n';
  }

  return this.headerMessage + header + this.S4Afunctions + body + broadcasts;

};

WorldMorph.prototype.Arduino.headerMessage =
      '/* ============================================\n'
    + ' *        AUTO-Generated by Snap4Arduino       \n'
    + ' * ============================================\n'
    + ' *\n'
    + ' * Please review this sketch before pushing it.\n'
    + ' *\n'
    + ' * This is an experimental feature, and there  \n'
    + ' * are _several_ Snap!-related functionalities \n'
    + ' * that are, by definition, untranslatable to  \n'
    + ' * static, compiled languages.                 \n'
    + ' *\n'
    + ' * There is NO WARRANTY whatsoever that this   \n'
    + ' * sketch is going to work exactly in the same \n'
    + ' * way as the original Snap4Arduino script.    \n'
    + ' */\n\n';

WorldMorph.prototype.Arduino.processBroadcasts = function (hatBlocks) {
    var myself = this,
        fullCode = '\n\n';

    hatBlocks.forEach(function (each) {
        fullCode += myself.processBroadcast(each);
    });

    return fullCode;
};

WorldMorph.prototype.Arduino.processBroadcast = function (hatBlock, body) {
    var code = hatBlock.mappedCode().replace(/void "(.*)"\(\) {/g, 'void $1() {') + '\n}\n\n';
    return code;
};

WorldMorph.prototype.Arduino.S4Afunctions =
      '/* ============================================\n'
    + ' *                S4A functions                \n'
    + ' * ============================================\n'
    + ' *\n'
    + ' * The struct below contains functions meant to\n'
    + ' * simulate the same behavior as their analogues\n'
    + ' * in Snap4Arduino.\n'
    + ' *\n'
    + ' * These don\'t need any configuration (unlike\n'
    + ' * pinMode).\n'
    + ' */\n\n'
    + 'typedef struct {\n'
    + '  boolean pins[TOTAL_PINS];\n'
    + '  int math(char op,int num) {\n'
    + '    int result = 0;\n'
    + '    switch(op){\n'
    + '      case \'abs\':\n'
    + '        result = abs(num);\n'
    + '        break;\n'
    + '      case \'ceiling\':\n'
    + '        result = ceil(num);\n'
    + '        break;\n'
    + '      case \'floor\':\n'
    + '        result = floor(num);\n'
    + '        break;\n'
    + '      case \'sqrt\':\n'
    + '        result = sqrt(num);\n'
    + '        break;\n'
    + '      case \'sin\':\n'
    + '        result = sin(num * DEG_TO_RAD);\n'
    + '        break;\n'
    + '      case \'cos\':\n'
    + '        result = cos(num * DEG_TO_RAD);\n'
    + '        break;\n'
    + '      case \'tan\':\n'
    + '        result = tan(num * DEG_TO_RAD);\n'
    + '        break;\n'
    + '      case \'asin\':\n'
    + '        result = RAD_TO_DEG * (asin(num));\n'
    + '        break;\n'
    + '      case \'acos\':\n'
    + '        result = RAD_TO_DEG * (acos(num));\n'
    + '        break;\n'
    + '      case \'atan\':\n'
    + '        result = RAD_TO_DEG * (atan(num));\n'
    + '        break;\n'
    + '      case \'ln\':\n'
    + '        result = log(num);\n'
    + '        break;\n'
    + '      case \'log\':\n'
    + '        result = log10(num);\n'
    + '        break;\n'
    + '      case \'e\':\n'
    + '        result = exp(num);\n'
    + '        break;\n'
    + '      case \'10\':\n'
    + '        result = pow(10,num);\n'
    + '        break;\n'
    + '      default:\n'
    + '        result = 0;\n'
    + '        break;\n'
    + '    }\n'
    + '    return result;\n'
    + '  }\n\n'
    + '  void digitalWrite(int pin, boolean level) {\n'
    + '    if (!pins[pin]){\n'
    + '      pinMode(pin,OUTPUT);\n'
    + '      pins[pin] = 1;\n'
    + '    }\n'
    + '    ::digitalWrite(pin, level);\n'
    + '  }\n\n'
    + '  void analogWrite(int pin, int value) {\n'
    + '    if (!pins[pin]){\n'
    + '      pinMode(pin,OUTPUT);\n'
    + '      pins[pin] = 1;\n'
    + '    }\n'
    + '    ::analogWrite(pin, value);\n'
    + '  }\n\n'
    + '  boolean digitalRead(int pin) {\n'
    + '    if (pins[pin]){\n'
    + '      pinMode(pin,INPUT);\n'
    + '      pins[pin] = 0;\n'
    + '    }\n'
    + '    return ::digitalRead(pin);\n'
    + '  }\n\n'
    + '  int analogRead(int pin) {\n'
    + '    if (pins[pin]){\n'
    + '      pinMode(pin,INPUT);\n'
    + '      pins[pin] = 0;\n'
    + '    }\n'
    + '   return ::analogRead(pin);\n'
    + '  }\n\n'
    + '  void servoWrite(int pin, int value) {\n'
    + '    if (value == -1) {\n'
    + '      if (servoPinMap[pin] != 255) {\n'
    + '        servos[servoPinMap[pin]].detach();\n'
    + '        // if we\'re detaching the last servo, decrement the count\n'
    + '        // otherwise store the index of the detached servo\n'
    + '        if (servoPinMap[pin] == servoCount && servoCount > 0) {\n'
    + '          servoCount--;\n'
    + '        } else if (servoCount > 0) {\n'
    + '          // keep track of detached servos because we want to reuse their indexes\n'
    + '          // before incrementing the count of attached servos\n'
    + '          detachedServoCount++;\n'
    + '          detachedServos[detachedServoCount - 1] = servoPinMap[pin];\n'
    + '        }\n'
    + '        servoPinMap[pin] = 255;\n'
    + '      }\n'
    + '      return;\n'
    + '    }\n'
    + '    if (servoPinMap[pin] == 255 || !servos[servoPinMap[pin]].attached()) {\n'
    + '      if (servoCount < MAX_SERVOS) {\n'
    + '        // reuse indexes of detached servos until all have been reallocated\n'
    + '        if (detachedServoCount > 0) {\n'
    + '          servoPinMap[pin] = detachedServos[detachedServoCount - 1];\n'
    + '          if (detachedServoCount > 0) detachedServoCount--;\n'
    + '        } else {\n'
    + '          servoPinMap[pin] = servoCount;\n'
    + '          servoCount++;\n'
    + '        }\n'
    + '        servos[servoPinMap[pin]].attach(PIN_TO_DIGITAL(pin), 600, 2400);\n'
    + '      }\n'
    + '    }\n'
    + '    servos[servoPinMap[pin]].write(value);\n'
    + '  }\n'
    + '} s4astruct, S4A;\n\n'
    + ' S4A s4a;\n\n'
    + '/* =============================================================================\n'
    + ' *                        Beginning of actual project code                      \n'
    + ' * =============================================================================\n'
    + ' */\n\n';
