// init decorator

SpriteMorph.prototype.originalInit = SpriteMorph.prototype.init;
SpriteMorph.prototype.init = function(globals) {
    var myself = this;

    myself.originalInit(globals);

    myself.arduino = {
      firmwareVersion : int = 0,
      board : undefined,	// Reference to arduino board - to be created by new firmata.Board()
      port : undefined,
      connecting : false,	// Flag to avoid multiple attempts to connect
      disconnecting : false,  // Flag to avoid serialport communication when it is being closed
      justConnected: false,	// Flag to avoid double attempts
      receiveCheck:int = 0,
      intervalCheck:int = 0,
      //////////////////////////
      errorCheck:int = 0,
      totalReceiveCheck:int = 0,
      //////////////////////////
      messageStep: int = 0,
      exMessageStep : int = 0,
      dataPin: undefined,
      readValue: undefined,
      dataReady: undefined,
      dronePacket: null,
      exDronePacket: null,
      exControllerData: int = 0
    };

    myself.packets = {
      setServoPacket : new Uint8Array(6),
      setAnanlogPinPacket : new Uint8Array(6),
      setDigitalPinPacket : new Uint8Array(6),
      setDCMotorPacket : new Uint8Array(7),
      digitalReadingPacket : new Uint8Array(5),
      sevenSensorPacket : new Uint8Array(4),
    };

    myself.packetTable = {
      sendCounter : int = 0,
      loopExit : false,

      setServoPointer : int = 0,
      setAnalogPinPointer : int = 0,
      setDigitalPinPointer : int = 0,
      setDCMotorPointer :int = 0,
      digitalReadingPointer : int = 0,

      setServoSendEn : undefined,
      setAnalogPinSendEn : undefined,
      setDigitalPinSendEn : undefined,
      setDCMotorSendEn : undefined,
      digitalReadingSendEn : undefined,
      sevenSensorSendEn : int = 0,
    };

    myself.smartInventor = {
      packetMachine : undefined,
    };

    myself.message = {
      ready : int = 0,
      connecting : int = 1,
      dataNotReceiveDisconnected : int = 2,
      totallyDisconnected : int = 3,
      connectedButNotConfirmed : int = 4,
      connectedAndConfirmed : int = 5,
      running : int = 6,
    };


    myself.arduino.disconnect = function(silent) {

        console.log(myself.arduino.messageStep);
        if (this.isBoardReady()) { // Prevent disconnection attempts before board is actually connected
            this.connecting = false;
            this.justConnected = false;
            myself.arduino.totalReceiveCheck  = 0;
            myself.arduino.streamingOff(); console.log("stream off!");
            clearInterval(myself.arduino.connectionCheck);
            clearInterval(myself.arduino.sendingDataIntervalCheck);
            myself.arduino.packetSender(false);
            this.board.close();
            this.closeHandler(silent);
          } else if (!this.board) {  // Don't send info message if the board has been connected
             if (!silent) {
               //console.log("messageSTEP: " + myself.arduino.messageStep);
               if((myself.arduino.messageStep == myself.message.ready)||(myself.arduino.messageStep == myself.message.running)) {
                  ide.inform(myself.name, localize('Board is not connected'));
               }
            }
        }
        //myself.arduino.messageStep = myself.message.ready;
    }


    // This should belong to the IDE
    myself.arduino.showMessage = function(msg) {
        if (!this.message) { this.message = new DialogBoxMorph() };

        var txt = new TextMorph(
                msg,
                this.fontSize,
                this.fontStyle,
                true,
                false,
                'center',
                null,
                null,
                MorphicPreferences.isFlat ? null : new Point(1, 1),
                new Color(255, 255, 255)
                );

        if (!this.message.key) { this.message.key = 'message' + myself.name + msg };

        this.message.labelString = myself.name;
        this.message.createLabel();
        if (msg) { this.message.addBody(txt) };
        this.message.drawNew();
        this.message.fixLayout();
        this.message.popUp(world);
        this.message.show();
    }

    myself.arduino.hideMessage = function() {
        if (this.message) {
            this.message.cancel();
            this.message = null;
        }
    }

    myself.arduino.attemptConnection = function() {

        if (!this.connecting) {
            //if (this.board === undefined) {
                // Get list of ports (Arduino compatible)
                var ports = world.Arduino.getSerialPorts(function(ports) {
                    // Check if there is at least one port on ports object (which for some reason was defined as an array)
                    if (Object.keys(ports).length == 0) {
                        ide.inform(myself.name, localize('Could not connect an device\nNo boards found'));
                        return;
                    } //else if (Object.keys(ports).length == 1) {
                        //myself.arduino.connect(ports[Object.keys(ports)[0]]);}
                      else if (Object.keys(ports).length >= 1) {
                        var portMenu = new MenuMorph(this, 'select a port');
                        Object.keys(ports).forEach(function(each) {
                            portMenu.addItem(each, function() {
                                myself.arduino.port = each;
                                myself.arduino.connect(each);
                            })
                        });
                        portMenu.popUpAtHand(world);
                    }
                });
        //    } else {
          //      ide.inform(myself.name, localize('There is already a board connected to this sprite'));
            //}
        }
        else {ide.inform(myself.name, localize('There is already a board connected to this sprite')); }

        if (this.justConnected) {
            this.justConnected = undefined;
            return;
        }

    }

    myself.arduino.closeHandler = function(silent) {

        var portName = 'unknown',
            thisArduino = myself.arduino;

        if (thisArduino.board) {
            portName = thisArduino.board.path;
            thisArduino.board = undefined;
        };

        world.Arduino.unlockPort(thisArduino.port);
        thisArduino.connecting = false;
        thisArduino.disconnecting = false;

        if (thisArduino.disconnected & !silent) {
            ide.inform(myself.name, localize('Board was disconnected from port\n') + portName + '\n\nIt seems that someone pulled the cable!');
            thisArduino.disconnected = false;
        } else if (!silent) {
          if(myself.arduino.messageStep != myself.message.dataNotReceiveDisconnected) {
            myself.arduino.hideMessage();
            ide.inform(myself.name, localize('Board was disconnected from port\n') + portName);
            myself.arduino.messageStep = myself.message.ready;
          }
        }
    }

    myself.arduino.disconnectHandler = function() {
        // This fires up when the cable is plugged, but only in recent versions of the serialport plugin
        myself.arduino.disconnected = true;
    }

    myself.arduino.errorHandler = function(err) {
        ide.inform(myself.name, localize('An error was detected on the board\n\n') + err, myself.arduino.disconnect(true));
    }

    myself.arduino.packetSender = function(stat) {
      var temp = 0, i = 0, pointer = 0, category = 0;

      if(stat == true)  myself.smartInventor.packetMachine = setInterval(function() {

        myself.packetTable.loopExit = false;

        while(myself.packetTable.loopExit == false) {

          if((myself.packetTable.sendCounter >= 0)&&(myself.packetTable.sendCounter < 32))   category =  Process.prototype.packetTable.setServo;
          else if((myself.packetTable.sendCounter >= 32)&&(myself.packetTable.sendCounter < 64))  category =  Process.prototype.packetTable.setAnalogPin;
          else if((myself.packetTable.sendCounter >= 64)&&(myself.packetTable.sendCounter < 96)) category =  Process.prototype.packetTable.setDigitalPin;
          else if((myself.packetTable.sendCounter >= 96)&&(myself.packetTable.sendCounter < 128)) category =  Process.prototype.packetTable.setDCMotor;
          else if((myself.packetTable.sendCounter >= 128)&&(myself.packetTable.sendCounter < 160)) category = Process.prototype.packetTable.setDigitalReading;
          else if(myself.packetTable.sendCounter == 161) category = Process.prototype.packetTable.sevenSensor;
          pointer = myself.packetTable.sendCounter;
          switch(category) {

            case Process.prototype.packetTable.setServo :
              if( myself.packetTable.setServoSendEn[pointer] > 0 ) {
                  myself.packetTable.setServoSendEn[pointer]--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x03, 0x04, pointer, Process.prototype.exData.exServoValue[pointer]]), function() {
                    myself.arduino.board.drain();
                  });
                  myself.packetTable.loopExit = true;
              }
            break;

            case Process.prototype.packetTable.setAnalogPin :
              pointer = pointer - 32;
              if( myself.packetTable.setAnalogPinSendEn[pointer] > 0 ) {
                  myself.packetTable.setAnalogPinSendEn[pointer]--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x03, 0x06, pointer, Process.prototype.exData.exAnalogValue[pointer]]), function() {
                    myself.arduino.board.drain();
                });
                myself.packetTable.loopExit = true;
              }
            break;

            case Process.prototype.packetTable.setDigitalPin :
              pointer = pointer - 64;
              if( myself.packetTable.setDigitalPinSendEn[pointer] > 0 ) {
                  myself.packetTable.setDigitalPinSendEn[pointer]--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x03, 0x03, pointer, Process.prototype.exData.exDigitalValue[pointer]]), function() {
                    myself.arduino.board.drain();
                  });
                  myself.packetTable.loopExit = true;
              }
            break;

            case Process.prototype.packetTable.setDCMotor :
              pointer = pointer - 96;
              if( myself.packetTable.setDCMotorSendEn[pointer] > 0 ) {
                  myself.packetTable.setDCMotorSendEn[pointer]--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x04, 0x01, pointer, Process.prototype.exData.exMotorDir[pointer], Process.prototype.exData.exMotorSpeed[pointer]]), function() {
                    myself.arduino.board.drain();
                  });

                  myself.packetTable.loopExit = true;
              }
            break;

            case Process.prototype.packetTable.setDigitalReading :
              pointer = pointer - 128;
              if( myself.packetTable.digitalReadingSendEn[pointer] > 0 ) {
                  myself.packetTable.digitalReadingSendEn[pointer]--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x02, 0x02, pointer]), function() {
                    myself.arduino.board.drain();
                  });

                  myself.packetTable.loopExit = true;
              }
            break;

            case Process.prototype.packetTable.sevenSensor :
              if( myself.packetTable.sevenSensorSendEn > 0 ) {
                  myself.packetTable.sevenSensorSendEn--;
                  myself.arduino.board.write(new Buffer([0xFF, 0XFF, 0x01, 0x07]), function() {
                    myself.arduino.board.drain();
                  });

                  myself.packetTable.loopExit = true;
              }
            break;
          }

          myself.packetTable.sendCounter++;
          if(myself.packetTable.sendCounter > 161)  { myself.packetTable.sendCounter = 0; myself.packetTable.loopExit = true; }
       }

     }, 40);
      else if(stat == false) clearInterval(myself.smartInventor.packetMachine);
    }

    myself.arduino.connect = function(port) {
          //this.disconnect(true);
        //this.showMessage(localize('Connecting board at port\n') + port);
        myself.arduino.messageStep = myself.message.connecting;
        var SerialPort = require("serialport");
        //var SerialPort = require("browser-serialport").SerialPort;
        //var parsers = require('browser-serialport').parsers;
        var informTxt = 'Try the following.\n'+
        '1)Check to see if the board is powered on.    \n'+
        ' 2)Check if your board is connected other port.\n'+
        '3)Check if the board does not supported.      \n\n'+
        'Except for the first case,\nIt is recommend to diconnect with the device and Check the problem.';

        //this.board = new SerialPort(port, {baudrate:57600, parser: parsers.readline('\n')});
        this.board = new SerialPort(port, {baudRate:57600});
        this.disconnecting = false;
        this.connecting = true;
        this.justConnected = true;
        this.port = port;
        myself.arduino.receiveCheck = 0;
        myself.arduino.intervalCheck = 0;
        myself.arduino.messageCheck = 0;
        world.Arduino.lockPort(port);

        Process.prototype.inputDataInit();
        Process.prototype.exDataInit();
        myself.arduino.receiveDataInit();
        myself.arduino.droneExDataInit();

        myself.arduino.messagePlayer = setInterval(function() {
          if(myself.arduino.messageStep != myself.arduino.exMassageStep) {
            myself.arduino.exMessageStep = myself.arduino.messageStep;
            if(myself.arduino.messageStep == myself.message.connecting ) {
              myself.arduino.showMessage(localize('Connecting board at port\n') + port);
            }
            else if(myself.arduino.messageStep == myself.message.dataNotReceiveDisconnected) {
              //myself.arduino.showMessage(localize('1Checking the connection at port\n') + port);
              clearInterval(myself.arduino.messagePlayer);
            }
            else if(myself.arduino.messageStep == myself.message.totallyDisconnected) {
              myself.arduino.hideMessage();
              ide.inform(myself.name, localize('There is a problem with communication.\nIt is forced to disconnect and check the problem.')+ '\n\n' + port + '\n');
              clearInterval(myself.arduino.messagePlayer);
              myself.arduino.messageStep = myself.message.ready;
            }
            else if(myself.arduino.messageStep == myself.message.connectedButNotConfirmed) {
              //myself.arduino.showMessage(localize('2Checking the connection at port\n') + port);
            }
            else if(myself.arduino.messageStep == myself.message.connectedAndConfirmed) {
              myself.arduino.hideMessage();
              ide.inform(myself.name, localize(' Board has been connected at port \n') + port);
              clearInterval(myself.arduino.messagePlayer);
              myself.arduino.messageStep = myself.message.running;
            }
          }
        }, 200);

        myself.arduino.board.on('close', function() {
          console.log('serialport event closed');
          myself.arduino.disconnect();
        });
        myself.arduino.board.on('error', function(error) {
           console.log('error'+ error );
           world.Arduino.unlockPort(port);
           this.connecting = false;
           this.justConnected = false;
           myself.arduino.closeHandler();
       });

        this.board.on("open", function() {
              console.log('serialport open');
              myself.arduino.packetSender(true);
              myself.arduino.sendStartPacket = setTimeout(function() {
                myself.arduino.connectingOn(); console.log("connecting On!");
                myself.arduino.streamingOn(); console.log("streaming On!");
              }, 500);


              myself.arduino.sendingDataIntervalCheck = setInterval(function() {
                //Process.prototype.exDataInit();
                myself.arduino.droneExDataInit();
                //console.log("drone buffer clear!");
              }, 2000);

              myself.arduino.connectionCheck = setInterval(function() {
                myself.arduino.intervalCheck++;
                if(myself.arduino.intervalCheck%5 == 0) {
                   myself.arduino.totalReceiveCheck =  myself.arduino.totalReceiveCheck + myself.arduino.receiveCheck;
                   if(myself.arduino.totalReceiveCheck > 100) {
                     if(myself.arduino.messageStep != myself.message.running)  { myself.arduino.messageStep = myself.message.connectedAndConfirmed; myself.arduino.errorCheck = 0; }
                   }
                   else myself.arduino.messageStep = myself.message.connectedButNotConfirmed;
                   myself.arduino.connectingOn(); console.log("connecing On!" +  myself.arduino.receiveCheck + " " + myself.arduino.totalReceiveCheck);
                }
                if(myself.arduino.intervalCheck >= 10) {
                  if(myself.arduino.receiveCheck < 1) {
                    myself.arduino.forceDroneFighterLanding();
                    myself.arduino.messageStep = myself.message.dataNotReceiveDisconnected;
                    myself.arduino.disconnect();
                    myself.arduino.errorCheck++;
                    clearInterval(myself.arduino.connectionCheck);

                    if(myself.arduino.errorCheck < 4) {
                      setTimeout( function() {
                        myself.arduino.connect(myself.arduino.port);
                      }, 1000);
                    }
                    else {
                      myself.arduino.errorCheck = 0;
                      myself.arduino.messageStep = myself.message.totallyDisconnected;
                      //myself.arduino.hideMessage();
                      //ide.inform(myself.name, localize('There is a problem with communication.\nIt is forced to disconnect and check the problem.')+ '\n\n' + port + '\n');
                    }
                  }
                  else {
                    myself.arduino.intervalCheck = 0;
                    myself.arduino.receiveCheck = 0;
                    myself.arduino.errorCheck = 0;
                  }
               }
              }, 200);

              this.connecting = false;
              myself.arduino.board.on('data', function(data) {
                var rData, dataNum, value;
                var pin, pinValues, pinStatus;
                //myself.arduino.receiveCheck++;
                //rData = parseInt(data);
                rData = new Buffer(data, 'utf8');
                if(isNaN(Number(rData))) {
                  if((rData[0] == 85)&&(rData[1] == 33)) {
                    Process.prototype.exData.batteryRemnant = parseInt(rData[6]);
                    console.log("battery:" + Process.prototype.exData.batteryRemnant);
                  }
                  myself.arduino.receiveCheck++;
                  //console.log(rData);              //when receiving dronefighter packet
                }
                else {
                  //console.log(Number(rData));       //when receiving smart inventor packet
                  if((Number(rData) >= 0)&&(Number(rData) < 1000000)) myself.arduino.receiveCheck++;
                  else if(Number(rData | 0x00) == 0) myself.arduino.receiveCheck++;
                  dataNum = rData >> 16;
                  value = rData & 0xFFFF;
                  //Filtering for Buletooth
                  if(dataNum == 0) {
                    if((myself.arduino.board.exControllerData == 10)&&(value > 0)&&(String(rData).indexOf("\n") > -1)) {
                      if((value >= 0)&&(value < 1024)) {
                        myself.arduino.board.readValue[dataNum] = value;
                        myself.arduino.board.dataReady[dataNum] = true;
                      //  console.log("NO: " + dataNum + " VALUE: " + value + " NUMBER: " + Number(rData));
                      }
                    }
                    myself.arduino.board.exControllerData = dataNum;
                  }
                  else if((dataNum > 0 )&&(dataNum < 7)) {
                    if((value >= 0)&&(value < 1024)) {
                      myself.arduino.board.readValue[dataNum] = value;
                      myself.arduino.board.dataReady[dataNum] = true;
                      //console.log("NO: " + dataNum + " VALUE: " + value + " NUMBER: " + Number(rData));
                    }
                    myself.arduino.board.exControllerData = dataNum;
                  }
                  else if(dataNum == 7) {
                    var temp  = (value & 0x00FF) * 4;
                    myself.arduino.board.readValue[dataNum] = temp;
                    myself.arduino.board.dataReady[dataNum] = true;
                    myself.arduino.firmwareVersion = (value & 0xFF00) >> 8;             //버전 계산
                    //console.log("NO: " + dataNum + " VALUE: " + temp + " NUMBER: " + Number(rData) + " version" + myself.arduino.firmwareVersion);
                  }
                  else if((dataNum >= 8)&&(dataNum < 11)) {
                    myself.arduino.board.readValue[dataNum] = value;
                    myself.arduino.board.dataReady[dataNum] = true;
                    //console.log("NO: " + dataNum + " VALUE: " + value + " NUMBER: " + Number(rData));
                    myself.arduino.board.exControllerData = dataNum;
                  }

                  if(myself.arduino.board.dataReady[8] == true) {
                      pinStatus = false;
                      for( pin = 8; pin <= 32; pin++) {
                        if((pin >= 8)&&(pin <= 10)) {
                          pinValues = myself.arduino.board.readValue[8];
                          pinValues = (((pinValues & 0x00FF) >> 5) >> (pin - 8)) & 0x0001;
                          if(pinValues == 1) pinStatus = false; else pinStatus = true;
                        }
                        else if((pin >= 22)&&(pin < 27)) {
                          pinValues = myself.arduino.board.readValue[8];
                          pinValues = ((pinValues & 0x00FF) >> (pin - 22)) & 0x0001;
                          if(pinValues == 1) pinStatus = false; else pinStatus = true;
                          //console.log(pinValues);
                        }
                        else if((pin >= 27)&&(pin < 32)){
                          pinValues = myself.arduino.board.readValue[8];
                          pinValues = (((pinValues & 0xFF00) >> 8) >> (pin - 27)) & 0x0001;
                          if(pinValues == 1) pinStatus = false; else pinStatus = true;
                        }
                        Process.prototype.exData.exDigitalInputValue[pin] = pinStatus;
                      }
                  }
                  if(myself.arduino.board.dataReady[10] == true) {
                    pinStatus = false;

                    for( pin = 11; pin <= 18; pin++) {
                      pinValues = myself.arduino.board.readValue[10];
                      pinValues = ((pinValues & 0x00FF) >> (pin - 11)) & 0x0001;
                      if(pinValues == 1) pinStatus = true; else pinStatus = false;
                      Process.prototype.exData.exDigitalInputValue[pin] = pinStatus;
                    }
                 }
                }
              });
              //myself.arduino.hideMessage();
              //ide.inform(myself.name, localize(' Board has been connected at port \n') + port);
       });
        return;
    }

    myself.arduino.receiveDataInit = function() {
      myself.arduino.board.readValue = {};
      myself.arduino.board.dataReady = {};
      myself.packetTable.setServoSendEn = {};
      myself.packetTable.setAnalogPinSendEn = {};
      myself.packetTable.setDigitalPinSendEn = {};
      myself.packetTable.setDCMotorSendEn = {};
      myself.packetTable.digitalReadingSendEn = {};


      for(var i = 0; i < 11; i++) {
        myself.arduino.board.readValue[i] = 0;
        myself.arduino.board.dataReady[i] = -1;
      }

      for (var i = 0; i <32; i++) {
        myself.packetTable.setServoSendEn[i] = 0;
        myself.packetTable.setAnalogPinSendEn[i] = 0;
        myself.packetTable.setDigitalPinSendEn[i] = 0;
        myself.packetTable.setDCMotorSendEn[i] = 0;
        myself.packetTable.digitalReadingSendEn[i] = 0;
      }

    }

    myself.arduino.droneExDataInit = function() {
      myself.arduino.board.dronePacket = {};
      myself.arduino.board.exDronePacket = {};

      for(var i = 0; i < 11; i++) {
        myself.arduino.board.dronePacket[i] = 0;
        myself.arduino.board.exDronePacket[i] = 0;
      }

      myself.arduino.board.dronePacket[0] = 0x0A;     //header
      myself.arduino.board.dronePacket[1] = 0x55;
      myself.arduino.board.dronePacket[2] = 0x20;    //control
      myself.arduino.board.dronePacket[3] = 0x05;    //length
    }

    myself.arduino.isBoardReady = function() {
        return ((this.board !== undefined)
              //  && (this.board.pins.length>0)
                && (!this.disconnecting));
    }

    myself.arduino.forceDroneFighterLanding = function() {
        if(myself.arduino.isBoardReady()) {
          myself.arduino.board.write( new Buffer([0x0A, 0x55, 0x20, 0x05, 0x00, 0x00, 0x00, 0x00, 0xA1, 0xC6]), function() {
          myself.arduino.board.drain();
         });
        }
        else {
           throw new Error(localize("Board not connected"));
       }
    }

    myself.arduino.streamingOn = function() {
        if(myself.arduino.isBoardReady()) {
          myself.arduino.board.write( new Buffer([0xFF, 0xFF, 0x01, 0x0B]), function() {
          myself.arduino.board.drain();
         });
        }
        else {
           throw new Error(localize("Board not connected"));
       }
    }

    myself.arduino.streamingOff = function() {
        if(myself.arduino.isBoardReady()) {
          myself.arduino.board.write( new Buffer([0xFF, 0xFF, 0x01, 0x0C]), function() {
          myself.arduino.board.drain();
         });
        }
        else {
           throw new Error(localize("Board not connected"));
       }
    }

    myself.arduino.connectingOn = function() {
        if(myself.arduino.isBoardReady()) {
          myself.arduino.board.write( new Buffer([0xFF, 0xFF, 0x01, 0x0D]), function() {
          myself.arduino.board.drain();
         });
        }
        else {
           throw new Error(localize("Board not connected"));
       }
    }
}

// Definition of a new Arduino Category

SpriteMorph.prototype.categories.push('Rokit');
SpriteMorph.prototype.blockColor['Rokit'] = new Color(64, 136, 182);

SpriteMorph.prototype.categories.push('Drone');
SpriteMorph.prototype.blockColor['Drone'] = new Color(105, 128,150);


SpriteMorph.prototype.originalInitBlocks = SpriteMorph.prototype.initBlocks;
SpriteMorph.prototype.initArduinoBlocks = function() {

    this.blocks.sendData =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'sending command',
       transpilable: true
    };

    this.blocks.throttle =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'throttle %throttleValue',
       defaults: ['0'],
       transpilable: true
    };

    this.blocks.yaw =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'yaw %yawValue',
       defaults: ['0'],
       transpilable: true
    };

    this.blocks.pitch =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'pitch %pitchValue',
       defaults: ['0'],
       transpilable: true
    };

    this.blocks.roll =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'roll %rollValue',
       defaults: ['0'],
       transpilable: true
    };

    this.blocks.pushEvent =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'event %eventName',
       defaults: ['STOP'],
       transpilable: true
    };

    this.blocks.pushTrim =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Drone',
       spec: 'trim %trimName',
       defaults: [null],
       transpilable: true
    };

    this.blocks.merongHello =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'merong %hello',
        defaults: ['100'],
        transpilable: true
    };

    this.blocks.setServo =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Rokit',
       spec: 'set servo %servoPin to %servoValue',
         defaults: [null, null],
       transpilable: true
    };

    this.blocks.setDigitalPin =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Rokit',
       spec: 'set digital pin %digitalPin to %b',
       defaults: [null],
       transpilable: true
    };

    this.blocks.setAnalogPin =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Rokit',
       spec: 'set analog pin %analogPin to %analogValue',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.setDCmotor =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Rokit',
       spec: 'DCmotor %motorNumber speed %motorSpeed with %direction',
       defaults: [null, null, null],
       transpilable: true
    };

    this.blocks.setTone =
    {
       only: SpriteMorph,
       type: 'command',
       category: 'Rokit',
       spec: 'tone %pitch note %duration',
       defaults: [null, null],
       transpilable: true
    };

    this.blocks.analogReading =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Rokit',
       spec: 'analog reading %sensor',
         defaults: ['19'],
       transpilable: true
    };

    this.blocks.digitalReading =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Rokit',
       spec: 'digital reading %digitalReportPin',
       defaults: ['22'],
       transpilable: true
    };

    this.blocks.sevenSensor =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Rokit',
       spec: 'seven sensor report',
       transpilable: true
    };

    this.blocks.IRRemocon =
    {
       only: SpriteMorph,
       type: 'reporter',
       category: 'Rokit',
       spec: 'IR Remocon report',
       transpilable: true
    };

    this.blocks.reportAnalogReading =
    {
        only: SpriteMorph,
        type: 'reporter',
        category: 'Rokit',
        spec: 'analog reading %analogPin',
        transpilable: true
    };

    this.blocks.reportDigitalReading =
    {
        only: SpriteMorph,
        type: 'reporter',
        category: 'Rokit',
        spec: 'digital reading %digitalPin',
        transpilable: true
    };

    this.blocks.connectArduino =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'connect arduino at %port'
    };

    // Keeping this block spec, although it's not used anymore!
    this.blocks.setPinMode =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'setup digital pin %digitalPin as %pinMode',
        defaults: [null, 'servo'],
        transpilable: true
    };

    this.blocks.digitalWrite =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'set digital pin %digitalPin to %b',
        transpilable: true
    };

    this.blocks.servoWrite =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'set servo %servoPin to %servoValue',
        defaults: [null, 'clockwise'],
        transpilable: true
    };

    this.blocks.pwmWrite =
    {
        only: SpriteMorph,
        type: 'command',
        category: 'Rokit',
        spec: 'set PWM pin %pwmPin to %n',
        transpilable: true
    };

    // Ardui... nization?
    // Whatever, let's dumb this language down:

    this.blocks.receiveGo.transpilable = true;
    this.blocks.receiveMessage.transpilable = true;
    this.blocks.doBroadcastAndWait.transpilable = true;
    this.blocks.doWait.transpilable = true;
    this.blocks.doWaitUntil.transpilable = true;
    this.blocks.doForever.transpilable = true;
    this.blocks.doRepeat.transpilable = true;
    this.blocks.doUntil.transpilable = true;
    this.blocks.doIf.transpilable = true;
    this.blocks.doIfElse.transpilable = true;
    this.blocks.reportSum.transpilable = true;
    this.blocks.reportDifference.transpilable = true;
    this.blocks.reportProduct.transpilable = true;
    this.blocks.reportQuotient.transpilable = true;
    this.blocks.reportModulus.transpilable = true;
    this.blocks.reportRound.transpilable = true;
    this.blocks.reportMonadic.transpilable = true;
    this.blocks.reportRandom.transpilable = true;
    this.blocks.reportLessThan.transpilable = true;
    this.blocks.reportEquals.transpilable = true;
    this.blocks.reportGreaterThan.transpilable = true;
    this.blocks.reportAnd.transpilable = true;
    this.blocks.reportOr.transpilable = true;
    this.blocks.reportNot.transpilable = true;
    this.blocks.reportBoolean.transpilable = true;
    this.blocks.doSetVar.transpilable = true;
    this.blocks.doChangeVar.transpilable = true;
    this.blocks.doDeclareVariables.transpilable = true;

    StageMorph.prototype.codeMappings['delim'] = ',';
    StageMorph.prototype.codeMappings['tempvars_delim'] = ', ';
    StageMorph.prototype.codeMappings['string'] = '"<#1>"';

    StageMorph.prototype.codeMappings['receiveGo'] = 'void setup() {';
    StageMorph.prototype.codeMappings['doBroadcastAndWait'] = '  !call!<#1>();';
    StageMorph.prototype.codeMappings['receiveMessage'] = 'void <#1>() {';

    StageMorph.prototype.codeMappings['doWait'] = '  delay(<#1> * 1000);';
    StageMorph.prototype.codeMappings['doWaitUntil'] = '  while(!<#1>){\n  }\n';
    StageMorph.prototype.codeMappings['doForever'] = '}\n\nvoid loop() {\n  <#1>\n}';
    StageMorph.prototype.codeMappings['doRepeat'] = '  for (int i = 0; i < <#1>; i++) {\n  <#2>\n  }';
    StageMorph.prototype.codeMappings['doUntil'] = '  while(!<#1>){\n  <#2>\n  }';
    StageMorph.prototype.codeMappings['doIf'] = '  if (<#1>) {\n  <#2>\n}';
    StageMorph.prototype.codeMappings['doIfElse'] = '  if (<#1>) {\n  <#2>\n} else {\n  <#3>\n}';

    StageMorph.prototype.codeMappings['reportSum'] = '(<#1> + <#2>)';
    StageMorph.prototype.codeMappings['reportDifference'] = '(<#1> - <#2>)';
    StageMorph.prototype.codeMappings['reportProduct'] = '(<#1> * <#2>)';
    StageMorph.prototype.codeMappings['reportQuotient'] = '(<#1> / <#2>)';
    StageMorph.prototype.codeMappings['reportModulus'] = '(<#1> % <#2>)';
    StageMorph.prototype.codeMappings['reportRound'] = 'round(<#1>)';
    StageMorph.prototype.codeMappings['reportMonadic'] = 's4a.math(<#1>,<#2>)';
    StageMorph.prototype.codeMappings['reportRandom'] = 'random(<#1>, <#2>+1)';
    StageMorph.prototype.codeMappings['reportLessThan'] = '(<#1> < <#2>)';
    StageMorph.prototype.codeMappings['reportEquals'] = '(<#1> == <#2>)';
    StageMorph.prototype.codeMappings['reportGreaterThan'] = '(<#1> > <#2>)';
    StageMorph.prototype.codeMappings['reportAnd'] = '(<#1> && <#2>)';
    StageMorph.prototype.codeMappings['reportOr'] = '(<#1> || <#2>)';
    StageMorph.prototype.codeMappings['reportNot'] = '!(<#1>)';
    StageMorph.prototype.codeMappings['reportBoolean'] = '<#1>';

    StageMorph.prototype.codeMappings['doSetVar'] = '  <#1> = <#2>;';
    StageMorph.prototype.codeMappings['doChangeVar'] = '  <#1> += <#2>;';
    StageMorph.prototype.codeMappings['doDeclareVariables'] = 'int <#1> = 0;'; // How do we deal with types? Damn types...

    StageMorph.prototype.codeMappings['sendData'] = 'SmartDroneControl.send();';
    StageMorph.prototype.codeMappings['throttle'] = 'THROTTLE = <#1>;';
    StageMorph.prototype.codeMappings['yaw'] = 'YAW = <#1>;';
    StageMorph.prototype.codeMappings['pitch'] = 'PITCH = <#1>;';
    StageMorph.prototype.codeMappings['roll'] = 'ROLL = <#1>;';
    StageMorph.prototype.codeMappings['pushEvent'] = 'SmartDroneControl.event = <#1>;';
    StageMorph.prototype.codeMappings['pushTrim'] = 'SmartDroneControl.event = <#1>;';
    //StageMorph.prototype.codeMappings['merongHello'] = 'analogRead(<#1>)';
    StageMorph.prototype.codeMappings['setServo'] = 'servo<#1>.write(<#2>);';
    StageMorph.prototype.codeMappings['setDigitalPin'] = 'digitalWrite(<#1>, <#2>));';
    StageMorph.prototype.codeMappings['setAnalogPin'] = 'analogWrite(<#1>, <#2>));';
    StageMorph.prototype.codeMappings['analogReading'] = 'analogRead(<#1>);';
    StageMorph.prototype.codeMappings['digitalReading'] = 'digitalRead(<#1>);';
    StageMorph.prototype.codeMappings['sevenSensor'] = 'sevenSensor();';
    StageMorph.prototype.codeMappings['IRRemocon'] = 'SmartInventor.RFRemoconData();';
    StageMorph.prototype.codeMappings['setDCmotor'] = 'SmartInventor.DCmotor(<#1>, <#2> ,<#3>);';
    StageMorph.prototype.codeMappings['setTone'] = 'tone(7, <#1>, <#2>);';
    //StageMorph.prototype.codeMappings['reportAnalogReading'] = 'analogRead(<#1>)';
    //StageMorph.prototype.codeMappings['reportDigitalReading'] = 'digitalRead(<#1>)';
    //StageMorph.prototype.codeMappings['setPinMode'] = 'pinMode(<#1>, <#2>);';
    //StageMorph.prototype.codeMappings['digitalWrite'] = 'digitalWrite(<#1>, <#2>);';
    //StageMorph.prototype.codeMappings['servoWrite'] = 'servo<#1>.write(<#2>);';
    //StageMorph.prototype.codeMappings['pwmWrite'] = 'analogWrite(<#1>, <#2>);';
}

SpriteMorph.prototype.initBlocks =  function() {
    this.originalInitBlocks();
    this.initArduinoBlocks();
}

SpriteMorph.prototype.initBlocks();

// blockTemplates decorator

SpriteMorph.prototype.originalBlockTemplates = SpriteMorph.prototype.blockTemplates;
SpriteMorph.prototype.blockTemplates = function(category) {
    var myself = this;

    var blocks = myself.originalBlockTemplates(category);

    //  Button that triggers a connection attempt

    var arduinoConnectButton = new PushButtonMorph(
            null,
            function () {
                myself.arduino.attemptConnection();
            },
            'Connect board'
            );

    //  Button that triggers a disconnection from board

    var arduinoDisconnectButton = new PushButtonMorph(
            null,
            function () {
                myself.arduino.disconnect();
            },
            'Disconnect board'
            );

	 var DroneConnectButton = new PushButtonMorph(
            null,
            function () {
                myself.arduino.attemptConnection();
            },
            'Connect Drone'
            );

    //  Button that triggers a disconnection from board

    var DroneDisconnectButton = new PushButtonMorph(
            null,
            function () {
                myself.arduino.disconnect();
            },
            'Disconnect Drone'
            );

    var ForcedLandingButton = new PushButtonMorph(
            null,
            function () {
                  myself.arduino.forceDroneFighterLanding();
            },
            'Forced Landing'
            );

    var streamingOnButton = new PushButtonMorph(
            null,
            function () {
                  myself.arduino.streamingOn();
            },
            'stream On'
            );

    var streamingOffButton = new PushButtonMorph(
            null,
            function () {
                  myself.arduino.streamingOff();
            },
            'stream off'
            );

    function blockBySelector(selector) {
        var newBlock = SpriteMorph.prototype.blockForSelector(selector, true);
        newBlock.isTemplate = true;
        return newBlock;
    };

    if (category === 'Rokit') {
        blocks.push(arduinoConnectButton);
        blocks.push(arduinoDisconnectButton);
        //blocks.push(streamingOnButton);
        //blocks.push(streamingOffButton);
        blocks.push('-');
        blocks.push(blockBySelector('sevenSensor'));
        blocks.push(blockBySelector('IRRemocon'));
        blocks.push('-');
        blocks.push(blockBySelector('analogReading'));
        blocks.push(blockBySelector('digitalReading'));

        //blocks.push(blockBySelector('pwmWrite'));
        //blocks.push(blockBySelector('merongHello'));
        blocks.push('-');
        blocks.push(blockBySelector('setServo'));
        blocks.push(blockBySelector('setDigitalPin'));
        blocks.push(blockBySelector('setAnalogPin'));
        blocks.push(blockBySelector('setDCmotor'));
        //blocks.push(blockBySelector('setTone'));
        //blocks.push(blockBySelector('reportAnalogReading'));
        //blocks.push(blockBySelector('reportDigitalReading'));
    };

	 if (category === 'Drone') {
      //blocks.push(DroneConnectButton);
      blocks.push(ForcedLandingButton);
	    blocks.push('-');
      blocks.push(blockBySelector('throttle'));
      blocks.push(blockBySelector('yaw'));
      blocks.push(blockBySelector('pitch'));
      blocks.push(blockBySelector('roll'));
      blocks.push(blockBySelector('pushEvent'));
      blocks.push(blockBySelector('pushTrim'));
      blocks.push(blockBySelector('sendData'));
     };

    return blocks;
}
