/*
	IOT.cpp	-	IOT	library
	Copyright	(C)	2014 RoboLink.	All	rights reserved.
	LastUpdate : 2020-06-24
*/

#include "IOT.h"
#include "Arduino.h"

#include <EEPROM.h>

SoftwareSerial softSerial(2, 3);

//------------------------------------ util ------------------------------------------//

int modeColor[] = {40, 75, 40};
int bootColor[] = {40, 75, 40};

byte recvBuff[MAX_PACKET_LENGTH];
byte checkHeader;
byte recvIndex;
byte recvDtype;
byte recvLength;

int sendRequest = 1;
int simulatorStart = true;

byte readData[5];

int soundCount = 0;
int soundCheck = 0;
int soundMn = 255;
int soundMx = 0;

int sendInterval = 50;


int _throttle = 0;
int _yaw = 0;
int _pitch = 0;
int _roll = 0;

//rokitbrick
bool timer1_on = false;
uint8_t _clr[3] = {};

uint8_t _actionPlayEvent = 0;

//------------------------------------------------------------------------------------//


void initailzie()
{
  Serial.begin(57600);
  softSerial.begin(RF_BAUDRATE);

  BuzzerInit();

  pinMode(MIC_PIN, INPUT);

  pinMode(BUT_L, INPUT_PULLUP);
  pinMode(BUT_R, INPUT_PULLUP);
  pinMode(BUT_D, INPUT_PULLUP);
  pinMode(BUT_U, INPUT_PULLUP);

  pinMode(LEFT_INPUT_PIN, INPUT_PULLUP);
  pinMode(RIGHT_INPUT_PIN, INPUT_PULLUP);

  NeoPixelInit();

  GyroCalibrationProcess();
  GyroInit();

  begin_serial(softSerial);

  if(timer1_on == false) 
   {
     timer1_on = true;
     Timer1.initialize(60000);
     Timer1.attachInterrupt(actionPlay); 
   }
}



//------------------------------------------------------------------------------------//
/*
int BootDisplay()
{
  byte triangle[]  = {0, 4, 8};

  for (int j = 0; j < 5 ; j++)
  {
    LEDPixelSet_Main(triangle[0], bootColor[0], bootColor[1], bootColor[2]);
    LEDPixelSet_Main(triangle[1], bootColor[0], bootColor[1], bootColor[2]);
    LEDPixelSet_Main(triangle[2], bootColor[0], bootColor[1], bootColor[2]);
    LEDShow_Main();

    //   for (int i = 0; i < MAIN_NUMPIXELS; i++)    LEDPixelSet_Main(i, 0, 0, 0);

    for (int k = 0; k < 3; k++)
    {
      for (int i = 0; i < 3; i++)
      {
        triangle[i]++;
        if (triangle[i] > 11) triangle[i] = 0;

        bootColor[0] += 10;
        bootColor[1] += 10;
        bootColor[2] += 10;
      }
    }

    delay(200);
  }
  for (int i = 0; i < MAIN_NUMPIXELS; i++)    LEDPixelSet_Main(i, 0, 0, 0);
  LEDShow_Main();


  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    LEDPixelSet_Main(i, 40, 35 + i * 5, 40);
    delay(55);
    LEDShow_Main();
  }

  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    LEDPixelSet_Main(i,0, 0, 0);
    delay(55);
    LEDShow_Main();
  }
}
*/
//------------------------------------------------------------------------------------//

/*
int ProgramSelection(int mode)
{
  int nowPos = 0;
  int brightAdjustment = 3;

  while (1)
  {
  	Simulator_Check();

    int butU = !digitalRead(BUT_U);
    int butL = !digitalRead(BUT_L);
    int butR = !digitalRead(BUT_R);
    int butD = !digitalRead(BUT_D);

    if (butD)
    {
      sound_4();
      do {
        delay(10);
      } while (!digitalRead(BUT_D));

      break;
    }

 		// BUTTON
    //------------------------------------------------------------//
    if (mode == BUTTON)
    {
      if (butL || butR)
      {
        sound_2();

        if (butL)
        {
          if (nowPos > 0)   nowPos--;
          do {
            delay(10);
          } while (!digitalRead(BUT_L));
        }

        else if (butR)
        {
          if (nowPos < 11)    nowPos++;
          do {
            delay(10);
          } while (!digitalRead(BUT_R));
        }
      }

      else if (butU)
      {
        Sound_Beep1();
        nowPos = ProgramSelection(GYRO);
        nowPos -= 1;
        break;
      }

      //dimming
      //-----------------------------------------------//
      if (TimeCheckWait(5))
      {
        modeColor[1] += brightAdjustment;
        if ((modeColor[1] <= 70) or (modeColor[1] >= 120))  brightAdjustment *= -1;
      }
      //-----------------------------------------------//

      LEDPixelSet_Main(nowPos + 1, 0, 0, 0);
      for (uint16_t _pos = 0; _pos <= nowPos; _pos++)
      {
        LEDPixelSet_Main(_pos, modeColor[0], modeColor[1], modeColor[2]);
        LEDShow_Main();
        delay(5);
      }
      //-----------------------------------------------//
    }

    // GYRO
    //------------------------------------------------------------//
    else if (mode == GYRO)
    {
      int offset = 5;

      GyroRead();
      int fb = eulerAngle(PITCH);
      int lr = eulerAngle(ROLL);
      double angle = (atan((double) abs(lr) / (double) abs (fb)) * 4068) / 71;

      if ((fb < -offset) or (fb > offset)) //forwad //backward
      {
        for (int i = 0; i < MAIN_NUMPIXELS; i++)    LEDPixelSet_Main(i, 0, 0, 0); // LED Clear

        if (lr < offset * -1) //left
        {
          if (fb < -offset) //forwad
          {
            if (angle < 45)       nowPos = 11;
            else if (angle > 45)  nowPos = 10;
          }
          else if (fb > offset) //backward
          {
            if (angle < 45)       nowPos = 7;
            else if (angle > 45)  nowPos = 8;
          }
        }
        else if (lr > offset) //right
        {
          if (fb < -offset) //forwad
          {
            if (angle < 45)       nowPos = 1;
            else if (angle > 45)  nowPos = 2;
          }
          else if (fb > offset) //backward
          {
            if (angle < 45)       nowPos = 5;
            else if (angle > 45)  nowPos = 4;
          }
        }
        else
        {
          if (fb < -offset)       nowPos = 0; //forwad
          else if (fb > offset)   nowPos = 6; //backward
        }

        LEDPixelSet_Main(nowPos, modeColor[0], modeColor[1], modeColor[2]); // LED Set
      }

      else if ((lr < -offset) or (lr > offset)) //forwad //backward
      {
        for (int i = 0; i < MAIN_NUMPIXELS; i++)    LEDPixelSet_Main(i, 0, 0, 0); // LED Clear
        if (lr < -offset)     nowPos = 9; //left
        else if (lr > offset) nowPos = 3; //right
        LEDPixelSet_Main(nowPos, modeColor[0], modeColor[1], modeColor[2]); // LED Set
      }

      LEDShow_Main(); // LED Display
    }
  }

  for (int i = 0; i < MAIN_NUMPIXELS; i++)    LEDPixelSet_Main(i, 0, 0, 0);
  LEDShow_Main();
  return nowPos + 1;
}
*/

//------------------------------------------------------------------------------------//




//---------------------------------------------------------------------------//
// for simulator
//---------------------------------------------------------------------------//
void AllSend(byte mic)  // Transmit angle value to "CoDrone 2" protocol
{
     
  if (sendRequest == 1)
  {
    byte butU = !digitalRead(BUT_U);
    byte butD = !digitalRead(BUT_D);
    byte butL = !digitalRead(BUT_L);
    byte butR = !digitalRead(BUT_R);
    
    long vccMilliVolts = readVccMilliVolts();
    double batteryVoltage = checkBattery(vccMilliVolts);
    byte  batPercent = batteryPercentage(batteryVoltage);

  // requestState( butU,  butD,  butL,  butR, micLV, batPercent);

    int left_x = analogRead(LEFT_ANALOG_PIN0);
    int left_y = analogRead(LEFT_ANALOG_PIN1);
    int left_b = !digitalRead(LEFT_INPUT_PIN);

    int right_y =  analogRead(RIGHT_ANALOG_PIN0);
    int right_x =  analogRead(RIGHT_ANALOG_PIN1);
    int right_b = !digitalRead(RIGHT_INPUT_PIN);

   // requestJoystick(left_x, left_y, left_b, right_x, right_y, right_b);

    byte but = (butU | (butD << 1) | (butL << 2 ) | (butR << 3) | (left_b << 4 ) | (right_b << 5))  ;

   // requestMotion(getACC(X), getACC(Y), getACC(Z), getGyro(X), getGyro(Y), getGyro(Z), eulerAngle(ROLL),  eulerAngle(PITCH), eulerAngle(YAW));


    byte accX_b = map((int)getACC(X), -32768, 32767, 0, 255);
    byte accY_b = map((int)getACC(Y), -32768, 32767, 0, 255);
    byte accZ_b = map((int)getACC(Z), -32768, 32767, 0, 255);
    
    //GyroRead();    
   
    while(GyroRead() == false);
    requestAll(accX_b, accY_b, accZ_b,                         //1,1,1
               eulerAngle(ROLL),  eulerAngle(PITCH), eulerAngle(YAW),   //2,2,2
               left_x, left_y, right_x, right_y,                        //1,1,1,1
               but, mic, batPercent                                     //1,1,1
               );          
  }
}


//------------------------------------------------------------------------------------//
//Receive

/*
void Simulator_Check()
{
  GyroRead();

  RFModuleReceive();
  RFModuleReceive_softserial();

	if(simulatorStart == true)
	{
		for (int i = 0; i < MAIN_NUMPIXELS; i++)	LEDPixelSet_Main(i, 0, 0, 0);
		LEDShow_Main();

		for (int i = 0; i < LEFT_NUMPIXELS; i++)	LEDPixelSet_Left(i, 0, 0, 0);
		LEDShow_Left();

		for (int i = 0; i < RIGHT_NUMPIXELS; i++)	LEDPixelSet_Right(i, 0, 0, 0);
		LEDShow_Right();

		while(1)
		{
		  GyroRead();

		  RFModuleReceive();
		  RFModuleReceive_softserial();

		  if (soundCount++ < 5)
		  {
		    int val = analogRead(MIC_PIN);
		    val = map(val, 0, 760, 0, 255);
		    soundMn = min(soundMn, val);
		    soundMx = max(soundMx, val);
		  }
		  else
		  {
		    soundCheck = soundMx - soundMn;
		    soundCount = 0;
		    soundMn = 255;
		    soundMx = 0;
		  }
		  if (TimeCheckRequest(sendInterval))
		  {
		    AllSend(soundCheck);
		  }
		}
	}
}
*/

void RFModuleReceive_softserial()
{
	while (softSerial.available() > 0)
  {
  	 byte input = softSerial.read();
		 ReceiveProcess(input, SEND_SERIAL_SOFT);
  }
}

void RFModuleReceive()
{
  while (Serial.available() > 0)
  {
    byte input = Serial.read();
  	ReceiveProcess(input, SEND_SERIAL_HW);
  }
}


void ReceiveProcess(byte input, byte sendSerial)
{
  recvBuff[recvIndex++] = (char)input;

  if (recvIndex >= MAX_PACKET_LENGTH)
  {
    checkHeader = 0;
    recvIndex = 0;
  }
  else
  {
    if (checkHeader == 0)
    {
      if (recvBuff[recvIndex - 1] == 0x0a)   checkHeader = 1;
    }
    else if (checkHeader == 1)
    {
      if (recvBuff[recvIndex - 1] == 0x55)
      {
        checkHeader = 2;
        recvIndex = 0;
      }
    }

    //------------------------------------------------------------------------------//
    //------------------------------------------------------------------------------//

    else if (checkHeader == 2)
    {
      if (recvIndex > 4)
      {
        recvLength = recvBuff[1]; // Receive Length

        if (recvLength > 0 && recvLength + 6 == recvIndex)
        {
          recvDtype = recvBuff[0];  // Receive Dtype
          byte crcBuff[2];

          crcBuff[0] = recvBuff[recvIndex - 2];
          crcBuff[1] = recvBuff[recvIndex - 1];

          if (CRC16_Check(recvBuff, recvLength + 2, crcBuff))
          {

            // Serial.println(recvDtype, HEX);

            /*
                // request
                if (recvDtype == 0x40)
                {
                  //  Serial.println(recvDtype, HEX);

                  if (recvLength == 0x16)
                  {
                    modeConnection = recvBuff[5];
                    //  Serial.println(recvBuff[5], HEX);
                    // linkModuleState++;
                  }
            }*/

            if (recvDtype == 0x44) //Motion
            {
            	simulatorStart = true;

            	if(sendSerial == SEND_SERIAL_HW)
	            {
	            	sendInterval = 5;
	            	set_serial(SEND_SERIAL_HW);


			           // LEDPixelSet_Left(1, 10, 10, 10);
		             //  LEDShow_Left();


	            }
            	else if(sendSerial == SEND_SERIAL_SOFT)
            	{
            		sendInterval = 5;
            		set_serial(SEND_SERIAL_SOFT);


		            //   LEDPixelSet_Right(1, 10, 10, 10);
		            //   LEDShow_Right();


            	}



              if (recvLength == 0x01)
              {
                byte _mode = recvBuff[4]; //0 = off //1 = on
                sendRequest = _mode;
                //WR_mainLED(6, rgba(255,103,47,1), ON);
              }
              if (sendRequest == 2)
              {
                GyroCalibration();
                sendRequest = 1;
              }
            }
/*
            else if (recvDtype == 0x71) //JoyStick
            {
              if (recvLength == 0x01)
              {
                byte _mode = recvBuff[4]; //0 = off //1 = on
                sendJoyStick = _mode;
              }
            }

            else if (recvDtype == 0x40) //State
            {
              if (recvLength == 0x01)
              {
                byte _mode = recvBuff[4]; //0 = off //1 = on
                sendState = _mode;
              }
            }
*/

            else if (recvDtype == 0x21) //LED
            {

              if (recvLength == 0x01) //LED show
              {
              //  byte _select = recvBuff[4] & 0x0f; //0 = main //1 = left // 2 = right
  							 byte _select = recvBuff[4]; //0 = main //1 = left // 2 = right

                if (_select == 0)  	  	LEDShow_Main();
                else if (_select == 1)  LEDShow_Left();
                else if (_select == 2)  LEDShow_Right();
              }

             // else if (recvLength == 0x05)   //LED Set
              else if (recvLength == 0x06)   //LED Set
              {
              	/*
                byte _select = recvBuff[4] & 0x0f; //0 = main //1 = left // 2 = right
                byte _id = (recvBuff[4] & 0xf0)>>4;
                byte _bright = recvBuff[5];

                byte _color_R = recvBuff[6];
                byte _color_G = recvBuff[7];
                byte _color_B = recvBuff[8];
								*/

                byte _select = recvBuff[4]; //0 = main //1 = left // 2 = right
                byte _id = recvBuff[5];
                byte _bright = recvBuff[6];

                byte _color_R = recvBuff[7];
                byte _color_G = recvBuff[8];
                byte _color_B = recvBuff[9];


                if (_select == 0)       LEDPixelSet_Main(_id, _color_R, _color_G, _color_B);
                else if (_select == 1)  LEDPixelSet_Left(_id, _color_R, _color_G, _color_B);
                else if (_select == 2)  LEDPixelSet_Right(_id, _color_R, _color_G, _color_B);

              }
            }

            else if (recvDtype == 0x62) //Buzzer
            {
              //   Serial.println(recvBuff[4], HEX);

              if (recvBuff[4] == 0)
              {
                noTone(BUZZER_PIN);
                // Serial.println("noTone");
              }
              else
              {
                int frequency = (recvBuff[5] | recvBuff[6] << 8);
                // Serial.println(frequency);
                unsigned long duration = (recvBuff[7] | recvBuff[8] << 8);
                tone(BUZZER_PIN, frequency, duration);
              }
            }

            // command
            else if (recvDtype == 0x11) //Command
            {
              // Serial.println(recvBuff[5], HEX);

              if (recvBuff[4] == 0x10)
              {
                _actionPlayEvent = START_EVENT;
                LEDPixelSet_Main(2, 100, 100, 100);
                LEDShow_Main();
              }
              else if (recvBuff[4] == 0x11)
              {
                _actionPlayEvent = SUCCESS_EVENT;
                LEDPixelSet_Main(3, 100, 100, 100);
                LEDShow_Main();
              }
              else if (recvBuff[4] == 0x12)
              {
                _actionPlayEvent = FAIL_EVENT;
                LEDPixelSet_Main(4, 100, 100, 100);
                LEDShow_Main();
              }
              else if (recvBuff[4] == 0x20)
              {
                _actionPlayEvent = SCORE_EVENT;
                LEDPixelSet_Main(8, 100, 100, 100);               
                LEDShow_Main();
              }
              else if (recvBuff[4] == 0x21)
              {
                _actionPlayEvent = SHOOT_EVENT;
                LEDPixelSet_Main(9, 100, 100, 100);                
                LEDShow_Main();
              }
              else if (recvBuff[4] == 0x22)
              {
                _actionPlayEvent = COLLISION_EVENT;            
                LEDPixelSet_Main(10, 100, 100, 100);
                LEDShow_Main();
              }
              //else 
              //{
                LEDPixelSet_Main(2, 0, 0, 0);
                LEDPixelSet_Main(3, 0, 0, 0);
                LEDPixelSet_Main(4, 0, 0, 0);
                LEDPixelSet_Main(8, 0, 0, 0);
                LEDPixelSet_Main(9, 0, 0, 0);
                LEDPixelSet_Main(10, 0, 0, 0);
                LEDShow_Main();
              //}

            }

          }

          checkHeader = 0;
          recvIndex = 0;
        }
      }
    }
    else
    {
      checkHeader = 0;
      recvIndex = 0;
    }
  }
}





//---------------------------------------------------------------------------//
//Codrone Control
//---------------------------------------------------------------------------//

int sendFlag = 0;

void CodroneMiniControl(int mode)
{

  int basicTerm = 25;
  int waitProcessTime = basicTerm;  // auto delay time

  int _throttle_Change = 5;
  int _pitch_roll_Change = 3;


  if (mode == GYRO)
  {
    //GyroRead();

    if (TimeCheckCodroneControl(waitProcessTime))
    // if (waitProcessTime <= 0)
    {
      int butL = !digitalRead(BUT_L);
      int butR = !digitalRead(BUT_R);
      int butD = !digitalRead(BUT_D);
      int butU = !digitalRead(BUT_U);

      //------------------------------------------------------------------------------//
      if (butU)
      {
        sendFlag = 1;
        waitProcessTime = 1000;
      }
      else if (butD)
      {
        sendFlag = 2;
      }

      //------------------------------------------------------------------------------//

      if (butL || butR)
      {
        if (butL)    // throttle up
        {
          if (_throttle < 100)  _throttle += + _throttle_Change;
        }
        else if (butR) //throttle down
        {
          if (_throttle > -100) _throttle -= _throttle_Change;
        }
      }
      else _throttle = 0;

      //------------------------------------------------------------------------------//

      if (eulerAngle(PITCH) < -30)
      {
        if (_pitch < 100) _pitch += _pitch_roll_Change;
      }
      else if (eulerAngle(PITCH) > 30)
      {
        if (_pitch > -100)  _pitch -= _pitch_roll_Change;
      }
      else  _pitch  = 0;

      //------------------------------------------------------------------------------//

      if (eulerAngle(ROLL) < -30)
      {
        if (_roll > -100) _roll -= _pitch_roll_Change;
      }
      else if (eulerAngle(ROLL) > 30)
      {
        if (_roll < 100)  _roll += _pitch_roll_Change;
      }
      else   _roll = 0;

      //------------------------------------------------------------------------------//

      if (sendFlag == 1)
      {
        flightEvent(TakeOff);
        sendFlag = 3;
      }
      else if (sendFlag == 2)
      {
        flightEvent(Stop);
        sendFlag = 0;
      }
      else if (sendFlag == 3) //return Takeoff Delay -> Basic Delay
      {
      	 waitProcessTime = basicTerm;
      	 sendFlag = 0;
      }
      else
      {
        moveBasedPower(_roll, _pitch, _yaw, _throttle);
      }
		  //------------------------------------------------------------------------------//

      // display gyro angle -> LED
			GyroDisplay_CoDrone(0, _pitch, _roll);
    }
  }

  else if (mode = JOYSTICK_ALL)
  {
    if (TimeCheckCodroneControl(waitProcessTime))
    {
	    int left_x = analogRead(LEFT_ANALOG_PIN0);
	    int left_y = analogRead(LEFT_ANALOG_PIN1);
		  int left_b = !digitalRead(LEFT_INPUT_PIN);

	    int right_x = analogRead(RIGHT_ANALOG_PIN1);
	    int right_y = analogRead(RIGHT_ANALOG_PIN0);
		  int right_b = !digitalRead(RIGHT_INPUT_PIN);

	    for (int i = 0; i < LEFT_NUMPIXELS; i++)	  LEDPixelSet_Left( i, random(0, 50), random(0, 50), random(0, 50));
	    for (int i = 0; i < RIGHT_NUMPIXELS; i++)	  LEDPixelSet_Right( i, random(0, 50), random(0, 50), random(0, 50));
	    LEDShow_Left();
	    LEDShow_Right();

	    if (left_b)
	    {
	      flightEvent(TakeOff);
	      delay(500);
	      do {
	        delay(10);
	      } while (!digitalRead(LEFT_INPUT_PIN));
	    }

	    else if (right_b)
	    {
	      flightEvent(Stop);
	      delay(500);
	      do {
	        delay(10);
	      } while (!digitalRead(RIGHT_INPUT_PIN));
	    }

	    int analogOffset = 10;

	    _throttle = map(left_y, 0, 1024, -100, 100);
	    _yaw = map(left_x, 0, 1024, 100, -100);
	    _pitch = map(right_y, 0, 1024, 100, -100);
	    _roll = map(right_x, 0, 1024, 100, -100);

	    if ((_throttle > -1 * analogOffset) && (_throttle < analogOffset)) _throttle = 0;
	    if ((_yaw > -1 * analogOffset) && (_yaw < analogOffset)) _yaw = 0;
	    if ((_pitch > -1 * analogOffset) && (_pitch < analogOffset)) _pitch = 0;
	    if ((_roll > -1 * analogOffset) && (_roll < analogOffset)) _roll = 0;

				/*
				Serial.print(left_b);
				Serial.print("\t");
				Serial.print(right_b);
				Serial.print("\t");
				Serial.print("\t");
				Serial.print(_throttle);
				Serial.print("\t");
				Serial.print(_yaw);
				Serial.print("\t");
				Serial.print(_pitch);
				Serial.print("\t");
				Serial.print(_roll);
				Serial.println("\t");
				*/

	    moveBasedPower(_roll, _pitch, _yaw, _throttle);
		}
  }
}


int backwardLed[] = {5, 6, 7};
int forwardLed[] = {11, 0, 1};
int rightLed[] = {2, 3, 4};
int leftLed[] = {8, 9, 10};

void GyroDisplay_CoDrone(int all, int fb, int lr)
{
	if (fb > 0)
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(forwardLed[i], 50, 0, 0);
  }
  else if (fb < 0)
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(backwardLed[i], 50, 50, 0);
  }
  else
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(forwardLed[i], 0, 0, 0);
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(backwardLed[i], 0, 0, 0);
  }

  if (lr < 0)
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(leftLed[i], 0, 50, 0);
  }
  else if (lr > 0)
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(rightLed[i], 0, 50, 50);
  }
  else
  {
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(leftLed[i], 0, 0, 0);
    for (int i = 0; i < 3; i++) LEDPixelSet_Main(rightLed[i], 0, 0, 0);
  }

  LEDShow_Main();
}

//------------------------------------------------------------------------------//
/*
int GyroAngleDisplay()
{
	int nowColor[] = {40, 75, 40};

  int nowPos = 0;
  int offset = 5;

  GyroRead();

  int fb = eulerAngle(PITCH);
  int lr = eulerAngle(ROLL);

  double angle = (atan((double) abs(lr) / (double) abs (fb)) * 4068) / 71;

  if ((fb < -offset) or (fb > offset)) //forwad //backward
  {
    for (int i = 0; i < MAIN_NUMPIXELS; i++)   LEDPixelSet_Main( 0, 255, 0, 0);

		//-----------------------------------------------------------//
    if (lr < offset * -1) //left
    {
      if (fb < -offset) //forwad
      {
        if (angle < 45)       nowPos = 11;
        else if (angle > 45)  nowPos = 10;
      }
      else if (fb > offset) //backward
      {
        if (angle < 45)       nowPos = 7;
        else if (angle > 45)  nowPos = 8;
      }
    }
		//-----------------------------------------------------------//
    else if (lr > offset) //right
    {
      if (fb < -offset) //forwad
      {
        if (angle < 45)       nowPos = 1;
        else if (angle > 45)  nowPos = 2;
      }
      else if (fb > offset) //backward
      {
        if (angle < 45)       nowPos = 5;
        else if (angle > 45)  nowPos = 4;
      }
    }
    //-----------------------------------------------------------//
    else
    {
      if (fb < -offset)       nowPos = 0; //forwad
      else if (fb > offset)   nowPos = 6; //backward
    }
		//-----------------------------------------------------------//
    LEDPixelSet_Main( nowPos, nowColor[0], nowColor[1], nowColor[2]);
  }

	//-----------------------------------------------------------//
  else if ((lr < -offset) or (lr > offset)) // forwad // backward
  {
    for (int i = 0; i < MAIN_NUMPIXELS; i++)	LEDPixelSet_Main( i, 255, 0, 0);
    if (lr < -offset)     nowPos = 9; //left
    else if (lr > offset) nowPos = 3; //right
    LEDPixelSet_Main( nowPos, nowColor[0], nowColor[1], nowColor[2]);
  }
  //-----------------------------------------------------------//
  LEDShow_Main();

  return nowPos + 1;
}
*/


//---------------------------------------------------------------------------//
// custom funtion
//---------------------------------------------------------------------------//

void GyroFishingRod()
{
  int offset = 10;

  GyroRead();

  boolean wheelState = false;
  boolean wheelisSpin = false;

  int spinCount = 0;

  float oldYaw = 0;
  int upCount = 0;
  int downCount = 0;

  int direction  = 0;

  int TIME_THRESHOLD = 500;
  long mLastTime = 0;

  oldYaw = eulerAngle(YAW);
  if (eulerAngle(PITCH) > 0) wheelState = true;

  while (1)
  {
    GyroRead();
    long now = millis();

    if (wheelState == true)
    {
      if (eulerAngle(PITCH) < 0)
      {
        spinCount++;
        wheelState = false;
      }
    }
    else if (wheelState == false)
    {
      if (eulerAngle(PITCH) > 0)
      {
        spinCount++;
        wheelState = true;
      }
    }

    if (eulerAngle(YAW) < oldYaw)  downCount++;
    else if (eulerAngle(YAW) > oldYaw)    upCount++;
    oldYaw = eulerAngle(YAW);

    if (spinCount == 0)
    {
      downCount = 0;
      upCount = 0;
    }

    if ((now - mLastTime) > TIME_THRESHOLD)
    {
      if (spinCount > 0)
      {
        wheelisSpin = true;
        spinCount = 0;

        if (downCount > upCount)     direction = 1;
        else  direction = 2;

        downCount = 0;
        upCount = 0;
      }
      else
      {
        direction = 0;
        downCount = 0;
        upCount = 0;
        wheelisSpin = false;
      }
      mLastTime = now;
    }

    Serial.print(direction);
    if (direction == 0) Serial.print("stop");
    if (direction == 1) Serial.print("up");
    if (direction == 2) Serial.print("down");
    Serial.print("\t");
    //  Serial.print(spinCount);
    //  Serial.print("\t");
    Serial.println(wheelisSpin);

  }

}




void GyroGlove()
{

/*
  GyroRead();
  Serial.print(getACC(X));
  Serial.print("\t");

  Serial.print(getACC(Y));
  Serial.print("\t");

  Serial.print(getACC(Z));
  Serial.print("\t");
*/

  double AcX = getACC(X);
  double AcY = getACC(Y);
  double AcZ = getACC(Z);


  float accel_x, accel_y, accel_z;
  float accel_xz, accel_yz;
  const float RADIANS_TO_DEGREES = 180 / 3.14159;

  accel_x = AcX - AcX;
  accel_y = AcY - AcY;
  accel_z = AcZ + (16384 - AcZ);

  accel_yz = sqrt(pow(accel_y, 2) + pow(accel_z, 2));
  float accel_angle_y = atan(-accel_x / accel_yz) * RADIANS_TO_DEGREES;

  accel_xz = sqrt(pow(accel_x, 2) + pow(accel_z, 2));
  float accel_angle_x = atan(accel_y / accel_xz) * RADIANS_TO_DEGREES;

  float accel_angle_z = 0;

/*
  Serial.print("\t");
  Serial.print(accel_angle_y);
  Serial.print("\t");

  Serial.print(accel_angle_x);
  Serial.println("\t");
*/
}


void GyroHandlebars()  // Transmit angle value to "CoDrone 2" protocol
{
  GyroRead();
  int offsetRoll = 10;
  int offsetPitch = 20;

	//----------------------------------------------------------------------------------//
  if (eulerAngle(PITCH) < offsetPitch and eulerAngle(PITCH) > -offsetPitch)
  {
  //  Serial.print("S");
  }
  else if (eulerAngle(PITCH) < -offsetPitch)
  {
  //  Serial.print("F");
  }
  else if (eulerAngle(PITCH) > offsetPitch)
  {
  //  Serial.print("B");
  }

 // Serial.print("\t");

	//----------------------------------------------------------------------------------//

  if (eulerAngle(ROLL) < offsetRoll and eulerAngle(ROLL) > -offsetRoll)
  {
  //  Serial.print("C");
  }

  else if (eulerAngle(ROLL) < -offsetRoll)
  {
 //   Serial.print("L");
  }

  else if (eulerAngle(ROLL) > offsetRoll)
  {
 //   Serial.print("R");
  }
	//----------------------------------------------------------------------------------//
/*
  Serial.print("\t");

  Serial.print(eulerAngle(ROLL));
  Serial.print("\t");

  Serial.print(eulerAngle(PITCH));
  Serial.print("\t");

  Serial.print(eulerAngle(YAW));
  Serial.println("\t");
  */

}


int GyroShake()
{
  int nowColor[] = {40, 75, 40};

  int SHAKE_DURATION = 1000;
  int SHAKE_COUNT = 3;

  int SHAKE_TIMEOUT = 500;
  float FORCE_THRESHOLD = 1000;
  int TIME_THRESHOLD = 100;

  int mShakeCount = 0;
  long mLastShake = 0;
  long mLastForce = 0;

 // Serial.println("test");

  delay(100);
  GyroRead();
  float mLastX = getACC(X);
  float mLastY = getACC(Y);
  float mLastZ = getACC(Z);

  long mLastTime = millis;
  int nowPos = 0;
  int detectLinear = 0;


  while (1)
  {
    long now = millis();

    GyroRead();
    if ((now - mLastForce) > SHAKE_TIMEOUT)    mShakeCount = 0;

    if ((now - mLastTime) > TIME_THRESHOLD)
    {

      long diff = now - mLastTime;
      float speed = abs(getACC(X) + getACC(Y) + getACC(Z) - mLastX - mLastY - mLastZ) / diff * 10;

      if (speed > FORCE_THRESHOLD)
      {
        if (detectLinear < 6) detectLinear += 1;

        if ((++mShakeCount >= SHAKE_COUNT) && (now - mLastShake > SHAKE_DURATION))
        {
          mLastShake = now;
          mShakeCount = 0;

         // Serial.println(speed);

          if (speed > 3000)
          {
          	for(int i =0; i < 3; i++) 	if (nowPos < 11) nowPos++;
          }
          else if (speed > 2000)
          {
          	for(int i =0; i < 2; i++) 	if (nowPos < 11) nowPos++;
          }
          else if (speed > 1000)
          {
          	for(int i =0; i < 1; i++) 	if (nowPos < 11) nowPos++;
          }

        }
        mLastForce = now;
      }

      else
      {
        if (detectLinear > 0) detectLinear -= 1;
        if (detectLinear == 0)
        {
          if (nowPos > 0)
          {
            detectLinear = 6;
            nowPos--;
          }
        }
      }
   //   Serial.println(detectLinear);
      mLastTime = now;
      mLastX = getACC(X);
      mLastY = getACC(Y);
      mLastZ = getACC(Z);
    }

    LEDPixelSet_Main( nowPos + 1, 255, 0, 0);

    for (uint16_t _pos = 0; _pos <= nowPos; _pos++)
    {
      LEDPixelSet_Main( _pos,  nowColor[0], nowColor[1], nowColor[2]);
      LEDShow_Main();
      delay(5);
    }
  }
}


int GyroShakeCheck()
{
  float xMin = 65500;
  float yMin = 65500;
  float zMin = 65500;

  float xMax = 0;
  float yMax = 0;
  float zMax = 0;

  float x = 0;
  float y = 0;
  float z = 0;

  float totalAccel = 0;

  int count = 0;

  int findShake = 0;

  int shake = 0;
  while (1)
  {
    GyroRead();

    float xAxis = getACC(X);
    float yAxis = getACC(Y);
    float zAxis = getACC(Z);

    xMin = min(xMin, xAxis);
    xMax = max(xMax, xAxis);

    yMin = min(yMin, yAxis);
    yMax = max(yMax, yAxis);

    zMin = min(zMin, zAxis);
    zMax = max(zMax, zAxis);

    count++;
    //   for (int i = 0; i < 10; i++) {
    x += xAxis;
    y += yAxis;
    z += zAxis;
    //    delay(1);
    //  }

    if (count == 10)
    {
      x /= 10;
      y /= 10;
      //    z /= 10;
      // float  totalAccel = sqrt(x * x + y * y + z * z);
      totalAccel = sqrt(x * x + y * y );
    //  Serial.println(totalAccel, 0);
      count = 0;

    }

    if (TimeCheckWait(100))
    {
      if(totalAccel > 10000)
      {
        findShake ++;
        //  Serial.println("SHAKE");
      }
      if(findShake > 5)
      {
        shake = 1;
     //   Serial.println("SHAKE");
        findShake = 0;
      }
    }
  }
  return shake;
}

void HandModules_Test()
{
	/*
  int left_b = !digitalRead(LEFT_INPUT_PIN);
  int left_x = analogRead(LEFT_ANALOG_PIN0);
  int left_y = analogRead(LEFT_ANALOG_PIN1);

  int right_b = !digitalRead(RIGHT_INPUT_PIN);
  int right_x = -1*analogRead(RIGHT_ANALOG_PIN1);
  int right_y = -1*analogRead(RIGHT_ANALOG_PIN0);

   for (int i = 0; i < LEFT_NUMPIXELS; i++)
  {
    if (left_b) LEDPixelSet_Left( i, 0, 150, 0);
    else        LEDPixelSet_Left( i, 150, 0, 0);
  }
  LEDShow_Left();

  for (int i = 0; i < RIGHT_NUMPIXELS; i++)
  {
    if (right_b)  LEDPixelSet_Right( i, 0, 150, 0);
    else          LEDPixelSet_Right( i, 150, 0, 0);
  }
  LEDShow_Right();
 */



		int left_x = analogRead(LEFT_ANALOG_PIN0);
		int left_y = analogRead(LEFT_ANALOG_PIN1);
		int left_b = !digitalRead(LEFT_INPUT_PIN);

		int right_y = analogRead(RIGHT_ANALOG_PIN0);
		int right_x = analogRead(RIGHT_ANALOG_PIN1);
		int right_b = !digitalRead(RIGHT_INPUT_PIN);

		_throttle = map(left_y, 0, 1024, -100, 100);
		_yaw 			= map(left_x, 0, 1024, 100, -100);

		_pitch 		= map(right_y, 0, 1024, 100, -100);
		_roll 		= map(right_x, 0, 1024, 100, -100);

			    int analogOffset = 10;
	    if ((_throttle > -1 * analogOffset) && (_throttle < analogOffset)) _throttle = 0;
	    if ((_yaw > -1 * analogOffset) && (_yaw < analogOffset)) _yaw = 0;
	    if ((_pitch > -1 * analogOffset) && (_pitch < analogOffset)) _pitch = 0;
	    if ((_roll > -1 * analogOffset) && (_roll < analogOffset)) _roll = 0;

Serial.print(left_b);
Serial.print("\t");
Serial.print(right_b);
Serial.print("\t");
Serial.print("\t");
Serial.print(_throttle);
Serial.print("\t");
Serial.print(_yaw);
Serial.print("\t");
Serial.print(_pitch);
Serial.print("\t");
Serial.print(_roll);
Serial.println("\t");


  for (int i = 0; i < LEFT_NUMPIXELS; i++)
  {
    if (left_b) LEDPixelSet_Left( i, 0, 150, 0);
    else        LEDPixelSet_Left( i, 150, 0, 0);
  }
  LEDShow_Left();

  for (int i = 0; i < RIGHT_NUMPIXELS; i++)
  {
    if (right_b)  LEDPixelSet_Right( i, 0, 150, 0);
    else          LEDPixelSet_Right( i, 150, 0, 0);
  }
  LEDShow_Right();

}

//------------------------------------------------------------------
//RokitBrick
//------------------------------------------------------------------

//For RokitBrick
/*
void blinkLED(void)
{
   static int ledState = LOW; 
  if (ledState == LOW) {
     ledState = HIGH;
     LEDPixelSet_Left(2, 200, 200, 0);
     LEDShow_Left();
    
  } else {
     ledState = LOW;
     LEDPixelSet_Left(2, 0, 0, 0);
     LEDShow_Left();
  }  
}
*/

//For Rokitbrick
void actionPlay()
{
  //LEDPixelSet_Left(2, 200, 200, 0);
  //LEDShow_Left();

 if(simulatorStart == false)
 {   
   //LEDPixelSet_Left(0, 200, 200, 0);
   LEDShow_Left();
   RFModuleReceive();
   RFModuleReceive_softserial();
 }   
  
 else if(simulatorStart == true)
 {
   //LEDPixelSet_Left(0, 0, 0, 0);
   LEDShow_Left();
   RFModuleReceive();
   RFModuleReceive_softserial();

    if (soundCount++ < 5)
    {
      int val = analogRead(MIC_PIN);
      val = map(val, 0, 760, 0, 255);
      soundMn = min(soundMn, val);
      soundMx = max(soundMx, val);
    }
    else
    {
      soundCheck = soundMx - soundMn;
      soundCount = 0;
      soundMn = 255;
      soundMx = 0;
    }
     AllSend(soundCheck);    
 }
}

bool WR_buttonInput(int btn) 
{
   if(btn == LEFT) return  (!digitalRead(BUT_L));
   else if(btn == RIGHT) return (!digitalRead(BUT_R));
   else if(btn == DOWN) return  (!digitalRead(BUT_D));
   else if(btn == UP) return  (!digitalRead(BUT_U));
   return 0;
}

int WR_leftJoystickInput(int axis)
{
   int j = 0;
   if(axis == VALUE_X) j = analogRead(A2);
   else if(axis == VALUE_Y) j = analogRead(A3);
   j = map(j, 0, 1024, -100, 100);
   return j;    
}

int WR_rightJoystickInput(int axis)
{
   int j = 0;
   if(axis == VALUE_X) j = analogRead(A1);
   else if(axis == VALUE_Y) j = analogRead(A0);
   j = map(j, 0, 1024, -100, 100);
   return j; 
}

int WR_MICInput()
{
   return ReadMic();
}

int WR_checkBattery()
{
   return checkBattery(readVccMilliVolts());
}

int WR_eulerAngle(int euler)
{  
   if(euler == YAW) return eulerAngle(YAW);
   else if(euler == PITCH) return eulerAngle(PITCH);
   else if(euler == ROLL) return eulerAngle(ROLL);
   else return 0;
}

void WR_LEDRGBControl(uint8_t board, uint8_t ledNum, int clr, bool onoff)
{
   if(board == MAIN) 
   {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 11) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Main(ledNum, _clr[0], _clr[1],_clr[2]);
      else LEDPixelSet_Main(ledNum, 0, 0, 0);
      LEDShow_Main();
   }
   else if(board == LEFT) 
   {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Left(ledNum, _clr[0], _clr[1],_clr[2]);
      else LEDPixelSet_Left(ledNum, 0, 0, 0);
      LEDShow_Left();
   }
   else if(board == RIGHT) 
   {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Right(ledNum, _clr[0], _clr[1],_clr[2]);
      else LEDPixelSet_Right(ledNum, 0, 0, 0);
      LEDShow_Right();
   }
}

void WR_LEDBrightControl(uint8_t board, uint8_t ledNum, uint8_t bright, bool onoff)
{
    if (bright < 0) bright = 0; else if(bright > 255) bright = 255;
    
    if(board == MAIN) 
    {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 11) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Main(ledNum, bright, bright, bright);
      else LEDPixelSet_Main(ledNum, 0, 0, 0);
      LEDShow_Main();
    }
    else if(board == LEFT) 
    {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Left(ledNum, bright, bright, bright);
      else LEDPixelSet_Left(ledNum, 0, 0, 0);
      LEDShow_Left();
    }
    else if(board == RIGHT) 
    {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Right(ledNum, bright, bright, bright);
      else LEDPixelSet_Right(ledNum, 0, 0, 0);
      LEDShow_Right();
    }
}

void WR_allLEDClear(int _board)
{
    if(_board == MAIN) 
    {
      for (int j = 0; j < 12; j++) 
      {
        LEDPixelSet_Main(j, 0, 0, 0);
      }
      LEDShow_Main();
    }
    else if(_board == LEFT)
    {
      for(int j = 0; j < 3; j++)
      {
        LEDPixelSet_Left(j, 0, 0, 0);
      }
      LEDShow_Left();
    }
    else if(_board == RIGHT)
    {
      for(int j = 0; j < 3; j++)
      {
        LEDPixelSet_Right(j, 0, 0, 0);
      }
      LEDShow_Right();
    }
}

void WR_LEDRGBSet(uint8_t board, uint8_t ledNum, uint8_t red, uint8_t green, uint8_t blue, bool onoff) 
{
  if(red < 0) red = 0; else if(red > 255) red = 255;
  if(green < 0) green = 0; else if(green > 255) green = 255;
  if(blue < 0) blue = 0; else if(blue > 255) blue = 255;
  
  if(board == MAIN) 
  {
    if(ledNum < 0) ledNum = 0; else if(ledNum > 11) ledNum = 0;
    if(onoff == ON) LEDPixelSet_Main(ledNum, red, green, blue);
    else LEDPixelSet_Main(ledNum, 0, 0, 0);
    LEDShow_Main();
  }
   else if(board == LEFT) 
   {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Left(ledNum, red, green, blue);
      else LEDPixelSet_Left(ledNum, 0, 0, 0);
      LEDShow_Left();
   }
   else if(board == RIGHT) 
   {
      if(ledNum < 0) ledNum = 0; else if(ledNum > 3) ledNum = 0;
      if(onoff == ON) LEDPixelSet_Right(ledNum, red, green, blue);
      else LEDPixelSet_Right(ledNum, 0, 0, 0);
      LEDShow_Right();
   }
}

void WR_LEDAnimation(int num, float wait)
{  
  if (wait < 0) wait = 0; 
  else if(wait > 2.55) wait = 2.55;
  uint8_t wt = (uint8_t)(wait * 1000);

   if (num == COLOR_WIPE) colorWipe(100, wt);
   else if(num == RAINBOW)  rainbow(wt);
   else if(num == RAINBOW_CYCLE) rainbowCycle(wt);
   else if(num == THEATER_CHASE) theaterChase(100, wt);
   else if(num == THEATER_CHASE_RAINBOW) theaterChaseRainbow(wt);
}

void WR_playNote(int pitch, int dur)
{
   tone(BUZZER_PIN, pitch, dur);
   int pauseBetweenNotes = dur * 1.30;
   delay(pauseBetweenNotes);
   noTone(BUZZER_PIN);    
}

void WR_soundEffect(int num)
{
   if(num == FIRE_BALL) Sound_FireBall();
   else if(num == COIN) Sound_Coin();
   else if(num == UP1)  Sound_1up();
   else if(num == BEEP1) Sound_Beep1();
   else if(num == BEEP2) Sound_Beep2();
   else if(num == SOUND_1) sound_1();
   else if(num == SOUND_2) sound_2();
   else if(num == SOUND_3) sound_3();
   else if(num == SOUND_4) sound_4();
   else if(num == CHARGING) chargingSound();
}

void WR_controlObject(int num)
{
   if(num == JOYSTICK_ALL) CodroneMiniControl(JOYSTICK_ALL);
   else if(num == GYRO) CodroneMiniControl(GYRO);
}

void WR_initialize()
{
   initailzie();
}

void WR_delay(float tm)
{
  delay(tm * 1000);
}

bool WR_actionPlayEvent(uint8_t _event) 
{
  if (_event == _actionPlayEvent) 
  {
    _actionPlayEvent = NONE_EVENT;
    return true;
  }
  else 
  {    
    return false;
  }
}

int rgba(uint8_t red, uint8_t green, uint8_t blue, uint8_t alpha)
{ 
   _clr[0] = red;  _clr[1] = green;  _clr[2] = blue;
    return 0;

}
