#include "IOT_Util.h"
#include "Arduino.h"
//------------------------------------------------------------------------------------//


long requestPreviousMillis = 0;
long codroneContolPreviousMillis = 0;
long WaitPreviousMillis = 0;

//------------------------------------------------------------------------------------//

/*
float ReadVoltage()
{
  int value = analogRead(BATCHECK_PIN);
  float vout = (value * 5.0) / 1023;
  float vin = vout / (R2 / (R1 + R2));
  return vin;
}
*/
long readVccMilliVolts()
{
  long result;
  // Read 1.1V reference against AVcc
  ADMUX = _BV(REFS0) | _BV(MUX3) | _BV(MUX2) | _BV(MUX1);
  delay(2);             // Wait for Vref to settle
  ADCSRA |= _BV(ADSC);  // Convert
  while (bit_is_set(ADCSRA, ADSC));
  result = ADCL;
  result |= ADCH << 8;
  result = 1126400L / result; // Back-calculate AVcc in mV
  return result;

  //return analogRead(BATCHECK_PIN) /  ( 1023.0 / (result * 0.001));
}
double checkBattery(long vccMilliVolts)
{
  //double bitsPerVolts = 1023.0 / (vccMilliVolts * 0.001);
  //double battLevel = analogRead(BATT_LVL_PIN) /  ( 1023.0 / (vccMilliVolts * 0.001));

  double result = analogRead(BATCHECK_PIN) /  (1023.0 / (vccMilliVolts * 0.001));
  result = result / (R2 / (R1 + R2));
  return result;
}

/*
double checkInputVCC(long vccMilliVolts)
{
  //If the Vcc rail = 5v then this value should equal 5 volts
  //double vcc =  (vccMilliVolts * 0.001) ;
  return (vccMilliVolts * 0.001);
}
*/

byte batteryPercentage(double batteryVoltage)
{
  byte battPercent = 0;
  //Each battery will reach different max voltages.
  //For example: 4.14, 4.19.
  if (batteryVoltage > MIN_BATTERY_VOLTAGE)
  {
    battPercent = (batteryVoltage - MIN_BATTERY_VOLTAGE) / (MAX_BATTERY_VOLTAGE - MIN_BATTERY_VOLTAGE) * 100;
  }

  if (battPercent > 100)
  {
    battPercent = 100;
  }
  else if (battPercent < 0)
  {
    battPercent = 0;
  }
  return battPercent;
}
//------------------------------------------------------------------------------------//

int ReadMic()
{
  int mn = 1024;     // mn only decreases
  int mx = 0;        // mx only increases

  for (int i = 0; i < 100; ++i)
  {
    int val = analogRead(MIC_PIN);
    // Serial.println(val);
    mn = min(mn, val);
    mx = max(mx, val);
  }

  return mx - mn;
}



//---------------------------------------------------------------------------//



boolean TimeCheckWait(word interval) //milliseconds
{
  boolean time = false;
  unsigned long currentMillis = millis();
  if (currentMillis - WaitPreviousMillis > interval)
  {
    WaitPreviousMillis = currentMillis;
    time = true;
  }
  return time;
}

//for simulator
boolean TimeCheckRequest(word interval) //milliseconds
{
  boolean time = false;
  unsigned long currentMillis = millis();
  if (currentMillis - requestPreviousMillis > interval)
  {
    requestPreviousMillis = currentMillis;
    time = true;
  }
  return time;
}


boolean TimeCheckCodroneControl(word interval) //milliseconds
{
  boolean time = false;
  unsigned long currentMillis = millis();
  if (currentMillis - codroneContolPreviousMillis > interval)
  {
    codroneContolPreviousMillis = currentMillis;
    time = true;
  }
  return time;	
}
