﻿
#include "IOT_LED.h"
#include "Arduino.h"


//------------------------------------ LED -------------------------------------------//

Adafruit_NeoPixel main_pixels = Adafruit_NeoPixel(MAIN_NUMPIXELS, NEOPIXEL_PIN, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel left_pixels = Adafruit_NeoPixel(LEFT_NUMPIXELS, LEFT_OUT_PIN, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel right_pixels = Adafruit_NeoPixel(RIGHT_NUMPIXELS, RIGHT_OUT_PIN, NEO_GRB + NEO_KHZ800);

//------------------------------------------------------------------------------------//


void LEDPixelSet_Main(byte select, byte r, byte g, byte b)
{	
  main_pixels.setPixelColor(select, main_pixels.Color(r, g, b));
}

void LEDPixelSet_Left(byte select, byte r, byte g, byte b)
{	
  left_pixels.setPixelColor(select, left_pixels.Color(r, g, b));
}

void LEDPixelSet_Right(byte select, byte r, byte g, byte b)
{	
  right_pixels.setPixelColor(select, right_pixels.Color(r, g, b));
}

//------------------------------------------------------------------------------------//

void LEDShow_Main()
{
  main_pixels.show();
  delayMicroseconds(10);
  // delay(1)
}
void LEDShow_Left()
{	  
  left_pixels.show();
  delayMicroseconds(10);
 // delay(1);
}
void LEDShow_Right()
{    
  right_pixels.show();
  delayMicroseconds(10);
 // delay(1);
}

//------------------------------------------------------------------------------------//

void NeoPixelInit()
{
  main_pixels.begin();
  for (int i = 0; i < MAIN_NUMPIXELS; i++)	main_pixels.setPixelColor(i, main_pixels.Color(0, 0, 0));
  main_pixels.show();

  left_pixels.begin(); // This initializes the NeoPixel library.
  for (int i = 0; i < LEFT_NUMPIXELS; i++)	left_pixels.setPixelColor(i, left_pixels.Color(0, 0, 0));
  left_pixels.show();

  right_pixels.begin(); // This initializes the NeoPixel library.
  for (int i = 0; i < RIGHT_NUMPIXELS; i++)	right_pixels.setPixelColor(i, right_pixels.Color(0, 0, 0));
  right_pixels.show();
}

void MainNeoPixelsTest(int delayval)
{
  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    main_pixels.setPixelColor(i, main_pixels.Color(0, 150, 0)); // Moderately bright green color.
    main_pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).
  }
  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    main_pixels.setPixelColor(i, main_pixels.Color(150, 0, 0)); // Moderately bright green color.
    main_pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).
  }
  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    main_pixels.setPixelColor(i, main_pixels.Color(0, 0, 150)); // Moderately bright green color.
    main_pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).
  }

  for (int i = 0; i < MAIN_NUMPIXELS; i++)
  {
    main_pixels.setPixelColor(i, main_pixels.Color(0, 0, 0)); // Moderately bright green color.
    main_pixels.show(); // This sends the updated pixel color to the hardware.
    delay(delayval); // Delay for a period of time (in milliseconds).
  }
}


void colorWipe(uint32_t c, uint8_t wait) {
  for (uint16_t i = 0; i < main_pixels.numPixels(); i++) {
    main_pixels.setPixelColor(i, c);
    main_pixels.show();
    delay(wait);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256; j++) {
    for (i = 0; i < main_pixels.numPixels(); i++) {
      main_pixels.setPixelColor(i, Wheel((i + j) & 255));
    }
    main_pixels.show();
    delay(wait);
  }
}

void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for (j = 0; j < 256 * 5; j++) { // 5 cycles of all colors on wheel
    for (i = 0; i < main_pixels.numPixels(); i++) {
      main_pixels.setPixelColor(i, Wheel(((i * 256 / main_pixels.numPixels()) + j) & 255));
    }
    main_pixels.show();
    delay(wait);
  }
}

void theaterChase(uint32_t c, uint8_t wait) {
  for (int j = 0; j < 10; j++) { //do 10 cycles of chasing
    for (int q = 0; q < 3; q++) {
      for (int i = 0; i < main_pixels.numPixels(); i = i + 3) {
        main_pixels.setPixelColor(i + q, c);  //turn every third pixel on
      }
      main_pixels.show();

      delay(wait);

      for (int i = 0; i < main_pixels.numPixels(); i = i + 3) {
        main_pixels.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}

//Theatre-style crawling lights with rainbow effect
void theaterChaseRainbow(uint8_t wait) {
  for (int j = 0; j < 256; j++) {   // cycle all 256 colors in the wheel
    for (int q = 0; q < 3; q++) {
      for (int i = 0; i < main_pixels.numPixels(); i = i + 3) {
        main_pixels.setPixelColor(i + q, Wheel( (i + j) % 255)); //turn every third pixel on
      }
      main_pixels.show();

      delay(wait);

      for (int i = 0; i < main_pixels.numPixels(); i = i + 3) {
        main_pixels.setPixelColor(i + q, 0);      //turn every third pixel off
      }
    }
  }
}


uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if (WheelPos < 85) {
    return main_pixels.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  } else if (WheelPos < 170) {
    WheelPos -= 85;
    return main_pixels.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  } else {
    WheelPos -= 170;
    return main_pixels.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
  }
}


