this.rokit = {
    usedPorts : new Array(),
    streamMsg : String,
    hardware : int = -1,
    streamingStatus : int = 0,
    progressCount : int = 0,
    delayCnt : int = 0,
    errCode : int = 0,
};

this.board = {
  nothing : int = -1,
  linky : int = 0,
  inventor : int = 1,
  zumi : int = 2,
  wearable : int = 3
};

this.streamingStatus = {
  wait : int = 0,
  onStreaming : int = 1,
  progStart : int = 2,
  progFinish : int = 3,
};

function fadeOut() {
  $('#title').animate({opacity:"0.3"}, 1);
  $('#selbox2').animate({opacity:"0.3"}, 1);
  $('#portButton').animate({opacity:"0.3"}, 1);
  $('#Wearable').animate({opacity:"0.3"}, 1);
  $('#WearableManual').animate({opacity:"0.3"}, 1);
  $('#WearableButton').animate({opacity:"0.3"}, 1);
  $('#Zumi').animate({opacity:"0.3"}, 1);
  $('#ZumiManual').animate({opacity:"0.3"}, 1);
  $('#ZumiButton').animate({opacity:"0.3"}, 1);
  $('#Linky').animate({opacity:"0.3"}, 1);
  $('#LinkyManual').animate({opacity:"0.3"}, 1);
  $('#LinkyButton').animate({opacity:"0.3"}, 1);
  $('#Inventor').animate({opacity:"0.3"}, 1);
  $('#InventorManual').animate({opacity:"0.3"}, 1);
  $('#InventorButton').animate({opacity:"0.3"}, 1);
  $('#myProgress').css("display","block");
  $('#myBar').css("display","block");
  $('#label').css("display","block");
  $('#message').css("display","block");
}

function fadeIn() {
  $('#myProgress').css("display","none");
  $('#myBar').css("display","none");
  $('#label').css("display","none");
  $('#message').css("display","none");
  $('#title').animate({opacity:"1.0"}, 1);
  $('#selbox2').animate({opacity:"1.0"}, 1);
  $('#portButton').animate({opacity:"1.0"}, 1);
  $('#Wearable').animate({opacity:"1.0"}, 1);
  $('#WearableManual').animate({opacity:"1.0"}, 1);
  $('#WearableButton').animate({opacity:"1.0"}, 1);
  $('#Zumi').animate({opacity:"1.0"}, 1);
  $('#ZumiManual').animate({opacity:"1.0"}, 1);
  $('#ZumiButton').animate({opacity:"1.0"}, 1);
  $('#Linky').animate({opacity:"1.0"}, 1);
  $('#LinkyManual').animate({opacity:"1.0"}, 1);
  $('#LinkyButton').animate({opacity:"1.0"}, 1);
  $('#Inventor').animate({opacity:"1.0"}, 1);
  $('#InventorManual').animate({opacity:"1.0"}, 1);
  $('#InventorButton').animate({opacity:"1.0"}, 1);
}



var Serialport = require('browser-serialport');

require('nw.gui').Window.get().on('close', function () {
    var myself = this;
    if(localStorage.getItem('upload') == 'ON')
    {
      if (confirm('아직 업로드 중입니다. 그래도 종료하시겠습니까?')) {
            console.log("window close!!");
            this.close(true);
      }
    }
    else this.close(true);
});

localStorage.setItem('upload', 'OFF');
localStorage.setItem('usedPort', 'NONE');

setTimeout(function(){
  addPorts();
  console.log("add ports!!");
}, 1000);

var portUse = localStorage.getItem("PORTUSE");
if(portUse == "ON") {
  setTimeout( function() {
    alert("업데이트를 하기 전에 먼저 로봇과의 연결을 해제하세요!");
  }, 1000);
}

var progressBarHandler = function(stat) {
  var myself = this;
  var bar = document.getElementById("myBar");
  var msg = document.getElementById("label");
    if(stat == true)  myself.progressBar = setInterval(function() {

      if(myself.rokit.hardware == myself.board.zumi) bar.style.background = "#3BD7D5";
      else if(myself.rokit.hardware == myself.board.linky) bar.style.background = "#F22AA40";
      else if(myself.rokit.hardware == myself.board.inventor) bar.style.background = "#7FCC47";

      bar.style.width = "" + myself.rokit.progressCount + "%";
      msg.innerHTML = "" + myself.rokit.progressCount + "%";
    }, 10);
    else clearInterval(myself.progressBar);
}

function uploadWearable() {
  var myself = this;
  var port;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn2 = document.getElementById('btn2');

  if(idx <= 0) {
    if(alert('먼저 업로드할 포트를 선택하세요!')) return;
  }
  else {
    var selectedPort = frm.ports.options[idx].text; console.log(selectedPort+ " " + idx);
    fadeOut();
    progressBarHandler(true);
    btn1.disabled = true;
    btn2.disabled = true;
    myself.rokit.hardware = myself.board.wearable;
    myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
    document.getElementById("message").innerHTML = "업로드를 시작합니다...";
    upload(selectedPort);
  }
}

function uploadLinky() {
  var myself = this;
  var port;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn2 = document.getElementById('btn2');

  if(idx <= 0) {
    if(alert('먼저 업로드할 포트를 선택하세요!')) return;
  }
  else {
    var selectedPort = frm.ports.options[idx].text; console.log(selectedPort+ " " + idx);
    fadeOut();
    progressBarHandler(true);
    btn1.disabled = true;
    btn2.disabled = true;
    myself.rokit.hardware = myself.board.linky;
    myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
    document.getElementById("message").innerHTML = "업로드를 시작합니다...";
    upload(selectedPort);
  }
}

function uploadZumi() {
  var myself = this;
  var port;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn2 = document.getElementById('btn2');

  if(idx <= 0) {
    if(alert('먼저 업로드할 포트를 선택하세요!')) return;
  }
  else {
    var selectedPort = frm.ports.options[idx].text; console.log(selectedPort+ " " + idx);
    fadeOut();
    progressBarHandler(true);
    btn1.disabled = true;
    btn2.disabled = true;
    myself.rokit.hardware = myself.board.zumi;
    myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
    document.getElementById("message").innerHTML = "업로드를 시작합니다...";
    upload(selectedPort);
  }
}

function uploadInventor() {
  var myself = this;
  var port;
  var frm = document.form2;
  var idx = frm.ports.selectedIndex;
  var btn1 = document.getElementById('btn1');
  var btn2 = document.getElementById('btn2');

  if(idx <= 0) {
    if(alert('먼저 업로드할 포트를 선택하세요!')) return;
  }
  else {
    var selectedPort = frm.ports.options[idx].text; console.log(selectedPort+ " " + idx);
    fadeOut();
    progressBarHandler(true);
    btn1.disabled = true;
    btn2.disabled = true;
    myself.rokit.hardware = myself.board.inventor;
    myself.rokit.streamingStatus = myself.streamingStatus.onStreaming;
    document.getElementById("message").innerHTML = "업로드를 시작합니다...";
    upload(selectedPort);
  }
}

function upload(port) {
  var myself = this;
  var avrdude;
  var streamMsg;
  var comPort = '-P'+ port;
  //console.log("comPort: " + comPort);
  var spawn = require('child_process').spawn;
  if (myself.rokit.hardware == myself.board.wearable) {
    avrdude = spawn('avrdude',['-C', 'avrdude.conf', '-v', '-patmega328p', '-carduino', comPort, '-b115200', '-D', '-Uflash:w:firmware/Wearable_firmware.hex:i'],  {cwd:'arduino'});
  }
  else if (myself.rokit.hardware == myself.board.linky) {
    avrdude = spawn('avrdude',['-C', 'avrdude.conf', '-v', '-patmega328p', '-carduino', comPort, '-b57600', '-D', '-Uflash:w:firmware/Linky_firmware.hex:i'],  {cwd:'arduino'});
  }
  else if (myself.rokit.hardware == myself.board.zumi) {
    avrdude = spawn('avrdude',['-C', 'avrdude.conf', '-v', '-patmega328p', '-carduino', comPort, '-b115200', '-D', '-Uflash:w:firmware/Zumi_firmware.hex:i'],  {cwd:'arduino'});
  }
  else if (myself.rokit.hardware == myself.board.inventor) {
    avrdude = spawn('avrdude',['-C', 'avrdude.conf', '-v', '-patmega32', '-carduino', comPort, '-b115200', '-D', '-Uflash:w:firmware/Inventor_firmware.hex:i'],  {cwd:'arduino'});
  }

  avrdude.stdout.on('data', (data) => {
    console.log(`stdout: ${data}`);
  });

  avrdude.stderr.on('data', (data) => {
    //console.log(`stderr: ${data}`);
    streamMsg = "" + data;
    if(myself.rokit.streamingStatus == myself.streamingStatus.onStreaming) {
        localStorage.setItem('upload', 'ON');
        if(streamMsg.indexOf('Writing') != -1 ) {
          myself.rokit.streamingStatus = myself.streamingStatus.progStart;
          document.getElementById("message").innerHTML = "업로드 중입니다...";
        }
        if(streamMsg.indexOf('not in sync')!= -1)  {
          myself.rokit.delayCnt++;
          document.getElementById("message").innerHTML = "전송이 지연되고 있습니다... 재시도중(" + myself.rokit.delayCnt +"/10)";
        }
    }
    else if(myself.rokit.streamingStatus == myself.streamingStatus.progStart) {
      var count = (streamMsg.match(/#/g) || []).length;
      myself.rokit.progressCount = myself.rokit.progressCount + count;
      if(myself.rokit.progressCount >= 100) myself.rokit.streamingStatus = myself.streamingStatus.progFinish;
    }
    else if(myself.rokit.streamingStatus == myself.streamingStatus.progFinish) {
      document.getElementById("message").innerHTML = "업로드를 완료하였습니다";
    }
    //console.log("PROGRESS:" + myself.rokit.progressCount + " " + myself.rokit.streamingStatus);
    console.log(streamMsg);
  });

  avrdude.on('close', (code) => {
    var myself = this;
    myself.rokit.errCode = code;
    setTimeout( function() {
      fadeIn();
      progressBarHandler(false);
      var btn1 = document.getElementById('btn1');
      var btn2 = document.getElementById('btn2');
      localStorage.setItem('upload', 'OFF');
      btn1.disabled = false;
      btn2.disabled = false;
      myself.rokit.progressCount = 0;
      myself.rokit.delayCnt = 0;
      myself.rokit.streamingStatus = myself.streamingStatus.wait;
      document.getElementById("message").innerHTML = "업로드를 시작합니다...";
      if(myself.rokit.errCode > 0) alert('업로드하지 못하였습니다. 연결 상태를 확인하세요');
    }, 2000);
    console.log(`child process exited with code ${code}`);
  });
}

function lockPort(port) {
  var usedPort = localStorage.getItem('usedPort');
  if(usedPort.indexOf(port) == -1)  {
   usedPort = usedPort + port;
   localStorage.setItem('usedPort', usedPort);
  }
}

function unlockPort(port) {
  var usedPort = localStorage.getItem('usedPort');
  if (usedPort.indexOf(port) > -1) {
    usedPort = usedPort.replace(port, "");
    localStorage.setItem('usedPort', usedPort);
  }
}

function isPortLocked(port) {
  var usedPort = localStorage.getItem('usedPort');
  console.log(usePorts);
  return (usedPort.indexOf(port) > -1);
}

var getSerialports = function(callback) {
  var myself = this.rokit;
  var portList = [];

  Serialport.list(function (err, ports) {
    if(ports) {
        ports.forEach(function(each) {
          console.log(each.comName); console.log(each.pnpId); console.log(each.manufacturer);
          //console.log(isPortLocked(each.comName));
          //if(isPortLocked(each.comName) == false) portList[each.comName] = each.comName;   //dictionary
           portList[each.comName] = each.comName;
        });
        portList = (Object.keys(portList));
        myself.portList = portList;
        callback(portList);
    }
  });
}

function addPorts(){
  var frm = document.form2;
  getSerialports(function(ports) {
    console.log(ports+ " " + frm.ports.length);
    var idx = frm.ports.length;
    while(idx > 1) {
      frm.ports.options.remove(idx - 1);
      idx--;
    }
    for (var k = 0; k < ports.length; k++) {
      var op = new Option();
      op.value = frm.ports.length;
      op.text = ports[k];
      op.selected = false;
      frm.ports.options.add(op);
      console.log(op);
    }
  });
}
