/*
    Changes to WorldMorph for managing Snap4Arduino functions
*/

/**
 * Global object (world.Arduino) used for s4a/arduino properties
 */
WorldMorph.prototype.Arduino = {
  //  firmata : require('firmata'),
    serialport : require('browser-serialport'),
    fs : require('fs'),
    portList : [],
    usedPorts : [],
    myVersion : 1.26,
    isChildOpen : false,
    scriptHeader : 1,
};

WorldMorph.prototype.Arduino.importVersion = function(ver, exVer) {
 var myself = this;
 myself.fs.readFile('arduino/firmware/versionInfo.txt', function(err, data) {
     if(err) {throw err; return -1;}
     var array = data.toString().split("\n");
     for (i in array) {
       //console.log(array[i]);
     }
     if(array[0].indexOf("robolink") != -1) {                              //�ٸ� ������ �ε� �Ǿ��ִ� ���� �Ǵ�
       exVer = array[4].replace("#app_rokitbrick:", "");
       console.log(exVer);
    }
    else {
      console.log("error!");
      exVer = myself.myVersion;
      console.log(exVer);
    }
 myself.versionInfoDownloadCompare(ver, exVer);
 });
}

WorldMorph.prototype.Arduino.versionInfoDownloadCompare = function(ver, exVer) {
  var myself = this;
  var download1 = require('download-file');
  var url = "http://robolink.ipdisk.co.kr:80/publist/HDD2/HDD2/firmware/versionInfo.txt";
  var options = {
      directory: "arduino/firmware",
      filename: "versionInfo.txt"
  }
  download1(url, options, function(err){
    if (err) throw err;

    myself.fs.readFile('arduino/firmware/versionInfo.txt', function(err, data) {
        if(err) {throw err; return -1; console.log(err);}
        var array = data.toString().split("\n");
        for (i in array) {
          //console.log(array[i]);
        }
        if(array[0].indexOf("robolink") != -1) {
          ver = array[4].replace("#app_rokitbrick:", "");
          console.log(ver);
        }
        else {
          ver = myself.myVersion;
        }
        exVer = parseFloat(exVer);
        ver = parseFloat(ver);
        //console.log(ver.inventor + " " + ver.linky + " " + ver.helperapp);
        if(ver > myself.myVersion) {
          setTimeout(function() {
            alert(localize('A newer version of Rokitbrick was found.\r\nDownload from www.robolinksw.com!'));
          }, 3000);
        }
    });
  });
}

/*
WorldMorph.prototype.Arduino.titleInfoImport = function() {
  var myself = this;
  var download1 = require('download-file');
  var url = "http://robolink.ipdisk.co.kr:80/publist/HDD2/HDD2/firmware/RBCodroneTitleInfo.html";
  var options = {
      directory: "info",
      filename: "RBCodroneTitleInfo.html"
  }
  download1(url, options, function(err){
    if (err) throw err;
  });
  console.log("info loaded!!");
}
*/

var appVersion = 0, exAppVersion = 0;
//WorldMorph.prototype.Arduino.titleInfoImport();

setTimeout(function() {
  ide.showMessage('It is the arduino code genertion mode. \r\n This is a bata version.' , 2.5);
}, 2000);

WorldMorph.prototype.Arduino.importVersion(appVersion, exAppVersion);



WorldMorph.prototype.Arduino.sleep = function(milliseconds) {
  var start = new Date().getTime();
  for (var i = 0; i < 1e7; i++) {
    if ((new Date().getTime() - start) > milliseconds){
        break;
      }
    }
}
/**
 * Locks the given port to prevent its use in other connection (until it is unlocked)
 */
WorldMorph.prototype.Arduino.lockPort = function (port) {
    var usedPorts = this.usedPorts;

    if (usedPorts.indexOf(port) === -1) {
        usedPorts.push(port);
    }
}

/**
 * Unlocks a previously Locked port to permit its use in new connections
 * Should be called when closing connections
 */
WorldMorph.prototype.Arduino.unlockPort = function (port) {
    var usedPorts = this.usedPorts;
    console.log("taken port: " + port);
    if (usedPorts.indexOf(port) > -1) {
        console.log("port index: " + usedPorts.indexOf(port));
        usedPorts.splice(usedPorts.indexOf(port), 1);
    }
}

/**
 * Informs whether the port is locked or unlocked
 */
WorldMorph.prototype.Arduino.isPortLocked = function (port) {
    return (this.usedPorts.indexOf(port) > -1)
}


/**
 * Gets a list of available serial ports (paths) and return it through callback function
 */
WorldMorph.prototype.Arduino.getSerialPorts = function (callback) {
    var myself = this;

    var portList = [];
    var portcheck = /usb|DevB|rfcomm|acm|^com/i; // Not sure about rfcomm! We must dig further how bluetooth works in Gnu/Linux

    myself.serialport.list(function (err, ports) {
        if (ports) {
            ports.forEach(function(each) {
                if(!myself.isPortLocked(each.comName) && portcheck.test(each.comName)) {
                    portList[each.comName] = each.comName;
                }
            });
        }
        callback(portList);
    });

};


WorldMorph.prototype.Arduino.transpile = function (body, hatBlocks) {
  var header = '',
      setupHeader = '',
      broadcasts = '',
      assignments = '';

      // First of all, let's deal with possible broadcasts
  if (body.indexOf('!call!') > 0) {
      // Message names are now function names, not strings
      body = body.replace(/!call!"(.*)"/g, '$1');
      broadcasts = this.processBroadcasts(hatBlocks, body);
  }

  console.log("mapped code!");
  header += '#include "IOT.h"\n';
  //if(WorldMorph.prototype.Arduino.scriptHeader == -1) header += '#define OLED_USE\n' + '#include "Zumi.h"\n';
  //else header += '#include "IOT.h"\n';

  varLines = body.match(/int .* = 0;/g) || [];
  body = body.replace(/int .* = 0;\n/g, '');
  varLines.forEach(function (each) {
      assignments += each + '\n';
  });

  body = assignments + '\n' + body;
  setupHeader += "";

  setupHeader +='\nWR_initialize();\n'
  

  body = body.replace('void setup() {', '$&' + setupHeader);
  body = body.replace(/, clockwise\)/g, ', 1200)');
  body = body.replace(/, stopped\)/g, ', 1500)');
  body = body.replace(/, counter-clockwise\)/g, ', 1800)');
  body = body.replace(/, disconnected\)/g, ', -1)');

    // If there's no loop function, we need to add an empty one
  if (body.indexOf('void loop()') < 0) {
      body += '\n}\n\nvoid loop() {}\n';
  }

  return this.headerMessage + header + this.S4Afunctions + body + broadcasts;

};

WorldMorph.prototype.Arduino.headerMessage = "";

WorldMorph.prototype.Arduino.processBroadcasts = function (hatBlocks) {
    var myself = this,
        fullCode = '\n\n';

    hatBlocks.forEach(function (each) {
        fullCode += myself.processBroadcast(each);
    });

    return fullCode;
};

WorldMorph.prototype.Arduino.processBroadcast = function (hatBlock, body) {
    var code = hatBlock.mappedCode().replace(/void "(.*)"\(\) {/g, 'void $1() {') + '\n}\n\n';
    return code;
};

WorldMorph.prototype.Arduino.S4Afunctions = "";
