function pinsSettableToMode(aMode) {
    // Retrieve a list of pins that support a particular mode
    var sprite = world.children[0].currentSprite,
        board = sprite.arduino.board;

    var pinNumbers = {};
    var pins = board.pins;
    pins.forEach(
        function(each){
            if (each.supportedModes.indexOf(aMode) > -1) {
                var number = pins.indexOf(each).toString();
                pinNumbers[number] = number;
            }
        }
    );
    return pinNumbers;
}


// labelPart() proxy

SyntaxElementMorph.prototype.originalLabelPart = SyntaxElementMorph.prototype.labelPart;

SyntaxElementMorph.prototype.labelPart = function(spec) {
    var part;
    switch (spec) {

        case '%tm':
            part = new InputSlotMorph(null, true);
        break;
 
        case '%WRButton':
            part = new InputSlotMorph(
                null,
                false,
                {
                    'UP' : ['UP'],
                    'DOWN': ['DOWN'],
                    'LEFT_' : ['LEFT_'],
                    'RIGHT_' : ['RIGHT_'],                   
                },
                true
        );
        break;

        case '%WRDevices':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'BUTTON':['BUTTON'],
                  'MIC':['MIC'],
                  'JOYSTICK':['JOYSTCIK'],
                  'GYRO':['GYRO']
                },
                true
        );
        break;

        case '%_board':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'MAIN':['MAIN'],
                  'LEFT':['LEFT'],
                  'RIGHT':['RIGHT'],
                },
                true
        );
        break;

        case '%LEDNum':
            part = new InputSlotMorph(null, true);
        break;

        case '%_bright':
            part = new InputSlotMorph(null, true);
        break;  
        
        case '%_red':
            part = new InputSlotMorph(null, true);
        break;
        
        case '%_green':
            part = new InputSlotMorph(null, true);
        break;
        
        case '%_blue':
            part = new InputSlotMorph(null, true);
        break;   

        case '%WRController':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'JOYSTICK_ALL':['JOYSTICK_ALL'],
                  'GYRO':['GYRO']                                   
                },
                true
        );
        break;
       
        case '%WRJoy':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'VALUE_X':['VALUE_X'],
                  'VALUE_Y':['VALUE_Y']
                },
                true
        );
        break;

        case '%animation':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'COLOR_WIPE':['COLOR_WIPE'],
                  'RAINBOW':['RAINBOW'],
                  'RAINBOW_CYCLE':['RAINBOW_CYCLE'],
                  'THEATER_CHASE':['THEATER_CHASE'],
                  'THEATER_CHASE_RAINBOW':['THEATER_CHASE_RAINBOW']
                },
                true
        );
        break;

        case '%WREffect':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'FIRE_BALL':['FIRE_BALL'],
                  'COIN':['COIN'],
                  'UP1':['UP1'],
                  'BEEP1':['BEEP1'],
                  'BEEP2':['BEEP2'],
                  'SOUND_1':['SOUND_1'],
                  'SOUND_2':['SOUND_2'],
                  'SOUND_3':['SOUND_3'],
                  'SOUND_4':['SOUND_4'],
                  'CHARGING':['CHARGING']
                },
                true
        );
        break;

        case '%pitch':
            part = new InputSlotMorph(
                null,
                false,
                {
                  '(INPUT)':null,
                  'C2':['NOTE_C2'],
                  'CS2':['NOTE_CS2'],
                  'D2':['NOTE_D2'],
                  'DS2':['NOTE_DS2'],
                  'E2':['NOTE_E2'],
                  'F2':['NOTE_F2'],
                  'FS2':['NOTE_FS2'],
                  'G2':['NOTE_G2'],
                  'GS2':['NOTE_GS2'],
                  'A2':['NOTE_A2'],
                  'AS2':['NOTE_AS2'],
                  'B2':['NOTE_B2'],
                  'C3':['NOTE_C3'],
                  'CS3':['NOTE_CS3'],
                  'D3':['NOTE_D3'],
                  'DS3':['NOTE_DS3'],
                  'E3':['NOTE_E3'],
                  'F3':['NOTE_F3'],
                  'FS3':['NOTE_FS3'],
                  'G3':['NOTE_G3'],
                  'GS3':['NOTE_GS3'],
                  'A3':['NOTE_A3'],
                  'AS3':['NOTE_AS3'],
                  'B3':['NOTE_B3'],
                  'C4':['NOTE_C4'],
                  'CS4':['NOTE_CS4'],
                  'D4':['NOTE_D4'],
                  'DS4':['NOTE_DS4'],
                  'E4':['NOTE_E4'],
                  'F4':['NOTE_F4'],
                  'FS4':['NOTE_FS4'],
                  'G4':['NOTE_G4'],
                  'GS4':['NOTE_GS4'],
                  'A4':['NOTE_A4'],
                  'AS4':['NOTE_AS4'],
                  'B4':['NOTE_B4'],
                  'C4':['NOTE_C4']
                },
                true
        );
        break;

        case '%duration':
            part = new InputSlotMorph(
                null,
                false,
                {
                  '(DIRECT_INPUT)':null,
                  'WHOLE_NOTE':['WHOLE_NOTE'],
                  'HALF_NOTE':['HALF_NOTE'],
                  'QUARTER_NOTE':['QUARTER_NOTE'],
                  'EIGHTH_NOTE':['EIGHTH_NOTE'],
                  'SIXTEENTH_NOTE':['SIXTEENTH_NOTE']
                },
                true
        );
        break;

        case '%euler':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'YAW':['YAW'],
                  'PITCH':['PITCH'],
                  'ROLL':['ROLL'],
                },
                true
        );
        break;

        case '%onOff':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'ON':['ON'],
                  'OFF':['OFF']
                },
                true
        );
        break;

        case '%gameEvent':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'START_EVENT':['START_EVENT'],
                  'SUCCESS_EVENT':['SUCCESS_EVENT'],
                  'FAIL_EVENT':['FAIL_EVENT']
                },
                true
        );
        break;

        case '%playerEvent':
            part = new InputSlotMorph(
                null,
                false,
                {
                  'SCORE_EVENT':['SCORE_EVENT'],
                  'SHOOT_EVENT':['SHOOT_EVENT'],
                  'COLLISION_EVENT':['COLLISION_EVENT'],
                },
                true
        );
        break;
        
        case '%fun':
            part = new InputSlotMorph(
                null,
                false,
                {
                    abs : ['ABS'],
                    ceiling : ['CEILING'],
                    floor : ['FLOOR'],
                    sqrt : ['SQRT'],
                    sin : ['SIN'],
                    cos : ['COS'],
                    tan : ['TAN'],
                    asin : ['ASIN'],
                    acos : ['ACOS'],
                    atan : ['ATAN'],
                    ln : ['LN'],
                    log : ['LOG'],
                    'e^' : ['EXP'],
                    '10^' : ['E10']
                },
                true
            );
            part.setContents(['SQRT']);
            break;
        default:
            part = this.originalLabelPart(spec);
    }
    return part;
}

BlockMorph.prototype.userMenu = function () {
    var menu = new MenuMorph(this),
        world = this.world(),
        myself = this,
        shiftClicked = world.currentKey === 16,
        alternatives,
        top,
        blck;

    menu.addItem(
        "help...",
        'showHelp'
    );
    if (shiftClicked) {
        top = this.topBlock();
        if (top instanceof ReporterBlockMorph) {
            menu.addItem(
                "script pic with result...",
                function () {
                    top.ExportResultPic();
                },
                'open a new window\n' +
                    'with a picture of both\nthis script and its result',
                new Color(100, 0, 0)
            );
        }
    }
    if (this.isTemplate) {
        if (!(this.parent instanceof SyntaxElementMorph)) {
            if (this.selector !== 'evaluateCustomBlock') {
                menu.addItem(
                    "hide",
                    'hidePrimitive'
                );
            }
        }
        return menu;
    }

    menu.addLine();
    if (this.selector === 'reportGetVar') {
        blck = this.fullCopy();
        blck.addShadow();
        menu.addItem(
            'rename...',
            function () {
                new DialogBoxMorph(
                    myself,
                    myself.setSpec,
                    myself
                ).prompt(
                    "Variable name",
                    myself.blockSpec,
                    world,
                    blck.fullImage(), // pic
                    InputSlotMorph.prototype.getVarNamesDict.call(myself)
                );
            }
        );
    } else if (SpriteMorph.prototype.blockAlternatives[this.selector]) {
        menu.addItem(
            'relabel...',
            function () {
                myself.relabel(
                    SpriteMorph.prototype.blockAlternatives[myself.selector]
                );
            }
        );
    } else if (this.definition && this.alternatives) { // custom block
        alternatives = this.alternatives();
        if (alternatives.length > 0) {
            menu.addItem(
                'relabel...',
                function () {myself.relabel(alternatives); }
            );
        }
    }

    menu.addItem(
        "duplicate",
        function () {
            var dup = myself.fullCopy(),
                ide = myself.parentThatIsA(IDE_Morph);
            dup.pickUp(world);
            if (ide) {
                world.hand.grabOrigin = {
                    origin: ide.palette,
                    position: ide.palette.center()
                };
            }
        },
        'make a copy\nand pick it up'
    );
    if (this instanceof CommandBlockMorph && this.nextBlock()) {
        menu.addItem(
            this.thumbnail(0.5, 60, false),
            function () {
                var cpy = this.fullCopy(),
                    nb = cpy.nextBlock(),
                    ide = myself.parentThatIsA(IDE_Morph);
                if (nb) {nb.destroy(); }
                cpy.pickUp(world);
                if (ide) {
                    world.hand.grabOrigin = {
                        origin: ide.palette,
                        position: ide.palette.center()
                    };
                }
            },
            'only duplicate this block'
        );
    }
    menu.addItem(
        "delete",
        'userDestroy'
    );
    menu.addItem(
        "script pic...",
        function () {
            window.open(myself.topBlock().fullImage().toDataURL());
        },
        'open a new window\nwith a picture of this script'
    );
    if (this.parentThatIsA(RingMorph)) {
        menu.addLine();
        menu.addItem("unringify", 'unringify');
        menu.addItem("ringify", 'ringify');
        return menu;
    }

    if (StageMorph.prototype.enableCodeMapping && this.selector == 'receiveGo') {
        menu.addLine();
        menu.addItem(
            'export as Arduino sketch...',
            'transpileTemp'
        );
    }

    if (this.parent instanceof ReporterSlotMorph
            || (this.parent instanceof CommandSlotMorph)
            || (this instanceof HatBlockMorph)
            || (this instanceof CommandBlockMorph
                && (this.topBlock() instanceof HatBlockMorph))) {
        return menu;
    }
    menu.addLine();
    menu.addItem("ringify", 'ringify');

    return menu;
};

BlockMorph.prototype.showMessage = function (message, secs) {
    var m = new MenuMorph(null, message),
        intervalHandle;
    m.popUpCenteredInWorld(this.world());
    if (secs) {
        intervalHandle = setInterval(function () {
            m.destroy();
            clearInterval(intervalHandle);
        }, secs * 1000);
    }
    return m;
};

BlockMorph.prototype.codeGenWindow = function(stat) {
    var myself = this;
    var mainWindow;
    //var codeGenWindow; 

    if(stat == 'open') {
        codeGenWindow = require('nw.gui').Window.open('codeGenerator.html', {
            width: 460,
            height: 600,
            min_width: 460,
            min_height: 600,
            focus:true
            },
            function(cWindows){
                cWindows.on('loaded', function() {
                    console.log("new window loaded!!: " + this); 
                    WorldMorph.prototype.Arduino.isChildOpen = true; 
                    
                    const promise = new Promise(resolve => {      
                        const confirm = setInterval(() => {
                           var msg = localStorage.getItem('M_WINDOW');
                           console.log("msg:" + msg);
                           if(msg == 'CLOSED') {
                              resolve();
                              console.log("pending finish!");
                              this.close(true);
                              clearInterval(confirm);        
                           }       
                        }, 1000);        
                    });                   
                });
                cWindows.on('closed', function() {
                    console.log("window closed!");
                    WorldMorph.prototype.Arduino.isChildOpen = false;
                });
                cWindows.on('document-end', function() {
                    console.log("document-end!");
                    //this.close();
                    WorldMorph.prototype.Arduino.isChildOpen = false;
                });
            },
        );
        //codeGenWindow.close();
        //mainWindow = require('nw.gui').Window.get();
        //mainWindow.close();          
    }
    else if(stat == 'close') {
        
        WorldMorph.prototype.Arduino.isChildOpen = false;
    }


}

BlockMorph.prototype.transpileTemp = function() {
  var myself = this;
  var fs = require('fs');
  var gui = require('nw.gui');
  var userHome = require('user-home');
  var msg = myself.showMessage("generating code...", 1.5);
  var codePath = userHome  + '/arduino121/code/genCode/genCode.ino';
  var rawCode = this.mappedCode();
  myself.confirmOLEDBlocks(rawCode);
  rawCode = myself.changeForLoopVar(rawCode);
  console.log("result : " + rawCode);

  var codes  =   this.world().Arduino.transpile(
        //this.mappedCode(),
        rawCode,
        this.parentThatIsA(ScriptsMorph).children.filter(
            function (each) {
                return each instanceof HatBlockMorph &&
                    each.selector == 'receiveMessage';
            }));

 //console.log(codes);
 fs.writeFile(codePath, codes, function(err) {
   if(err == null) {
     console.log('write file success');
   } else {
     console.log('write file fail' + err);
   }
 });

 if(WorldMorph.prototype.Arduino.isChildOpen == false) {

   WorldMorph.prototype.Arduino.isChildOpen = true;
   myself.codeGenWindow('open');
 }
 console.log(codes);
}

BlockMorph.prototype.confirmOLEDBlocks = function(rawCode) {
  var text1 = "OLEDAnimation";
  var text2  ="OLEDOutput";
  var text3 = "OLEDEyes";

  WorldMorph.prototype.Arduino.scriptHeader = 1;
  if((rawCode.indexOf(text1) != -1)||(rawCode.indexOf(text2) != -1)||(rawCode.indexOf(text3) != -1)) WorldMorph.prototype.Arduino.scriptHeader = -1;
  else   WorldMorph.prototype.Arduino.scriptHeader =   WorldMorph.prototype.Arduino.scriptHeader = 1;
}

BlockMorph.prototype.changeForLoopVar = function(rawCode) {
  var varName ="";
  var fullCode = "";
  var code = rawCode.split('\n');
  var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    for(var j = 0; j < code.length; j++) {
      varName = "";
      for(var k = 0; k < 2; k++) {
        varName += possible.charAt(Math.floor(Math.random() * possible.length))
      };

      varName = "_" + varName;
      code[j] = code[j].replace(/_var_/g, varName);
//      console.log(code[j]);
      fullCode += code[j] +"\n";
    }
  //console.log(fullCode);
  return fullCode;
};


BlockMorph.prototype.transpileToC = function () {
    var fs = require('fs');
        ide = this.parentThatIsA(IDE_Morph);
    try {
        saveFile(
                ide.projectName ? ide.projectName.replace(/[^a-zA-Z]/g,'') : 'snap4arduino',
                this.world().Arduino.transpile(
                    this.mappedCode(),
                    this.parentThatIsA(ScriptsMorph).children.filter(
                        function (each) {
                            return each instanceof HatBlockMorph &&
                                each.selector == 'receiveMessage';
                        })),
                '.ino',
                ide);
    } catch (error) {
        ide.inform('Error exporting to Arduino sketch!', error.message)
    }
};
